# macos-lib.pl
# Functions for parsing macos server ps output

sub list_processes
{
local($pcmd, $line, $i, %pidmap, @plist);
open(PS, "ps axlwwww $_[0] |");
for($i=0; $line=<PS>; $i++) {
	chop($line);
	if ($line =~ /ps axlwwww/ || $line =~ /^UID\s+PID/) { $i--; next; }
	$line =~ /^\s*(\d+)\s+(\d+)\s+(\S+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(\S+)\s+(\d+)\s+(...)\s+(\S+)\s+(\d+:\d+)\s+(.*)/;
	if ($3 <= 0) { $i--; next; }
	$plist[$i]->{"pid"} = $3;
	$plist[$i]->{"ppid"} = $4;
	$plist[$i]->{"size"} = $8;
	$plist[$i]->{"time"} = $13;
	$plist[$i]->{"nice"} = $6;
	$plist[$i]->{"_tty"} = $12 eq '?' ? $text{'edit_none'} : "/dev/tty$12";
	$plist[$i]->{"args"} = $14;
	$pidmap{$3} = $plist[$i];
	}
close(PS);
open(PS, "ps auxwwww $_[0] |");
while($line = <PS>) {
	chop($line);
	$line =~ /^(\S+)\s+(\d+)\s+(\S+)\s+(\S+)/ || next;
	if ($pidmap{$2}) {
		$pidmap{$2}->{"user"} = $1;
		$pidmap{$2}->{"cpu"} = "$3 %";
		}
	}
close(PS);
return @plist;
}

# renice_proc(pid, nice)
sub renice_proc
{
$out = `renice $_[1] -p $_[0] 2>&1`;
if ($?) { return $out; }
return undef;
}

%info_arg_map=(	"_tty", $text{'macos_tty'} );

@nice_range = (-20 .. 20);

$has_fuser_command = 0;

1;

