#!/usr/local/bin/perl
#
# postfix-module by Guillaume Cottenceau <gc@mandrakesoft.com>,
# for webmin by Jamie Cameron
#
# Copyright (c) 2000 by Mandrakesoft
#
# Permission to use, copy, modify, and distribute this software and its
# documentation under the terms of the GNU General Public License is hereby 
# granted. No representations are made about the suitability of this software 
# for any purpose. It is provided "as is" without express or implied warranty.
# See the GNU General Public License for more details.
#
#
# Save, modify, delete an alias for Postfix


require './postfix-lib.pl';

&ReadParse();


$access{'aliases'} || &error($text{'aliases_ecannot'});

#      &header($text{'aliases_title'}, "");

&error_setup($text{'alias_save_err'});


$aliases = &get_aliases();
my $add = 1; my %alias;

foreach $trans (@{$aliases})
{
    if ($trans->{'number'} == $in{'num'}) { $add = 0; %alias = %{$trans}; }
}



my @aliases_files = &get_aliases_files(&get_current_value("alias_maps"));

defined($aliases_files[0]) || &error($text{'aliases_no_alias_file'});

if ($in{'delete'})
{
    if ($add == 1) { $whatfailed = ""; &error("Failed to delete alias: ".$text{'alias_delete_create'}); }
    my $all_aliases = &read_file_lines($alias{'alias_file'});
    splice(@{$all_aliases}, $alias{'line'}, 1);
    &flush_file_lines();
}
elsif ($add == 0)
{
    # modify an existing alias
    my $all_aliases = &read_file_lines($alias{'alias_file'});
    $all_aliases->[$alias{'line'}] = "$in{'name'}: $in{'value'}\n";
    &flush_file_lines();
}
else
{
    # add a new alias -- much more easy! :-)
    open(ALIASES, ">>$aliases_files[0]") or &error($text{'aliases_cant_write'});
    if ((print ALIASES "$in{'name'}: $in{'value'}\n") == 0) { &error($text{'aliases_cant_write'}); }
    close(ALIASES);
}
    


# re-creates aliases database

&regenerate_aliases();

&reload_postfix();

&redirect("aliases.cgi");




