#!/usr/local/bin/perl
#
# postfix-module by Guillaume Cottenceau <gc@mandrakesoft.com>,
# for webmin by Jamie Cameron
#
# Copyright (c) 2000 by Mandrakesoft
#
# Permission to use, copy, modify, and distribute this software and its
# documentation under the terms of the GNU General Public License is hereby 
# granted. No representations are made about the suitability of this software 
# for any purpose. It is provided "as is" without express or implied warranty.
# See the GNU General Public License for more details.
#
#
# A word about this module.
#
# Postfix provides a command to control its parameters: `postconf'.
# That's the reason why I don't parse and set the values manually.
# It's much better because it can resist to changes of the Postfix
# config files.
#
# However, to `set back to default' an already changed parameter,
# there is no way to do it in the case of dynamic parameters.
# [example: I mean that for `static' parameters, which defaults to
# `0', I can set the parameter to `0' ; but for `dynamic'
# parameters such as domainname [which comes from a system call]
# I have no way]
# So for this special case, I parse the config file, and delete
# manually the correct line.
#
# gc.
#


require './postfix-lib.pl';

&header($text{'index_title'}, "", "intro", 1, 1);
print "<hr>\n";

# Verify the postfix control command
if (!-x $config{'postfix_control_command'}) {
	print "<p>",&text('index_epath', "<tt>$config{'postfix_control_command'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Verify the postfix config command
if (!-x $config{'postfix_config_command'}) {
	print "<p>",&text('index_econfig', "<tt>$config{'postfix_config_command'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Verify that current configuration is valid
if (check_postfix()) {
	print "<p>",&text('check_error'),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}


@olinks =  ( "general.cgi", "rewrite.cgi", "aliases.cgi", "canonical.cgi", "virtual.cgi", "transport.cgi", "relocated.cgi",
	     "local_delivery.cgi", "resource.cgi",
	     "smtpd.cgi", "smtp.cgi",
	     "rate.cgi", "debug.cgi", "ldap.cgi" );

@otitles = ( "$text{'general_title'}", "$text{'address_rewriting_title'}", "$text{'aliases_title'}",
	     "$text{'canonical_title'}", "$text{'virtual_title'}", "$text{'transport_title'}", "$text{'relocated_title'}",
	     "$text{'local_delivery_title'}", "$text{'resource_title'}",
	     "$text{'smtpd_title'}", "$text{'smtp_title'}",
	     "$text{'rate_title'}", "$text{'debug_title'}", "$text{'ldap_title'}" ); 

@oicons =  ( "images/general.gif", "images/rewrite.gif", "images/aliases.gif",
	     "images/canonical.gif", "images/virtual.gif", "images/transport.gif", "images/relocated.gif",
	     "images/local_delivery.gif", "images/resource.gif",
	     "images/smtpd.gif", "images/smtp.gif",
	     "images/rate.gif", "images/debug.gif", "images/ldap.gif" );


&icons_table(\@olinks, \@otitles, \@oicons);


if ($access{'startstop'})
{
    print "<hr>\n";

    if (&is_postfix_running())
    {
	print "<table cellpadding=5 width=100%><tr><td>\n";
	print "<form action=stop.cgi>\n";
	print "<input type=submit value=\"$text{'index_stop'}\">\n";
	print "</td> <td>$text{'index_stopmsg'}\n";
    }
    else
    {
	print "<table cellpadding=5 width=100%><tr><td>\n";
	print "<form action=start.cgi>\n";
	print "<input type=submit value=\"$text{'index_start'}\">\n";
	print "</td> <td>$text{'index_startmsg'}\n";
    }
    print "</td></tr></table></form>\n";
}

print "<hr>\n";

&footer("/", $text{'index'});



