# mysql-lib.pl
# Common MySQL functions

do '../web-lib.pl';
&init_config();
$ENV{$gconfig{'ld_env'}} .= ':'.$config{'mysql_libs'};
%access = &get_module_acl();
$authstr = &make_authstr();
$master_db = 'mysql';

@type_list = ('tinyint', 'smallint', 'mediumint', 'int', 'bigint',
	    'float', 'double', 'decimal', 'date', 'datetime', 'timestamp',
	    'time', 'year', 'char', 'varchar', 'tinyblob', 'tinytext',
	    'blob', 'text', 'mediumblob', 'mediumtext', 'longblob', 'longtext',
	    'enum', 'set');

sub make_authstr
{
if ($access{'user'}) {
	return " -u '$access{'user'}'".
	       ($access{'pass'} ? " '-p$access{'pass'}'" : "");
	}
else {
	return ($config{'login'} ? " -u '$config{'login'}'" : "").
	       ($config{'pass'} ? " '-p$config{'pass'}'" : "");
	}
}

# is_mysql_running()
# Returns 1 if mysql is running, 0 if not, or -1 if running but
# inaccessible without a password
sub is_mysql_running
{
local $out = `$config{'mysqladmin'} $authstr ping 2>&1`;
return $out =~ /alive/i ? 1 :
       $out =~ /denied/i ? -1 : 0;
}

# list_databases()
# Returns a list of all databases
sub list_databases
{
open(DBS, "$config{'mysqlshow'} $authstr |");
local $t = &parse_mysql_table(DBS);
close(DBS);
return map { $_->[0] } @{$t->{'data'}};
}

# list_tables(database)
# Returns a list of tables in some database
sub list_tables
{
if ($_[0] =~ /_/) {
	open(DBS, "$config{'mysqlshow'} $authstr $_[0] % |");
	}
else {
	open(DBS, "$config{'mysqlshow'} $authstr $_[0] |");
	}
local $t = &parse_mysql_table(DBS);
close(DBS);
return map { $_->[0] } @{$t->{'data'}};
}

# table_structure(database, table)
# Returns a list of hashes detailing the structure of a table
sub table_structure
{
local $s = &execute_sql($_[0], "desc $_[1]");
local (@rv, $r);
foreach $r (@{$s->{'data'}}) {
	push(@rv, { 'field' => $r->[0],
		    'type' => $r->[1],
		    'null' => $r->[2],
		    'key' => $r->[3],
		    'default' => $r->[4],
		    'extra' => $r->[5] });
	}
return @rv;
}

# execute_sql(database, command)
# Executes some SQL and returns the results
sub execute_sql
{
local $temp = &tempname();
open(TEMP, ">$temp");
print TEMP $_[1],"\n";
close(TEMP);
#open(DBS, "$config{'mysql'} $authstr -e \"$_[1]\" -t $_[0] 2>&1 |");
open(DBS, "$config{'mysql'} $authstr -t $_[0] <$temp 2>&1 |");
local $t = &parse_mysql_table(DBS);
close(DBS);
unlink($temp);
if ($t =~ /^ERROR[^:]*:(.*)/) {
	&error(&text('esql', "<tt>$_[1]</tt>", "<tt>$1</tt>"));
	}
return $t;
}

# execute_sql_logged(database, command)
sub execute_sql_logged
{
&additional_log('sql', $_[0], $_[1]);
return &execute_sql(@_);
}

# parse_mysql_table(handle)
# Given a filehandle, parses a text table in the format mysql uses
sub parse_mysql_table
{
local $fh = $_[0];
local ($line, $i, @edge);
do {
	# skip to table top
	$line = <$fh>;
	return $line if ($line =~ /^ERROR/);
	} while($line && $line !~ /^\+/);
for($i=0; $i<length($line); $i++) {
	push(@edge, $i) if (substr($line, $i, 1) eq '+');
	}
$line = <$fh>;		# skip first row of -'s
local @titles = &parse_mysql_line($line, \@edge);
$line = <$fh>;		# skip next row of -'s
local @data;
while(1) {
	$line = <$fh>;
	last if (!$line || $line !~ /^\|/);
	push(@data, [ &parse_mysql_line($line, \@edge) ]);
	}
return { 'titles' => \@titles,
	 'data' => \@data };
}

# parse_mysql_line(line, &edges)
sub parse_mysql_line
{
local @rv;
for($i=0; $i<@{$_[1]}-1; $i++) {
	local $w = substr($_[0], $_[1]->[$i]+1,
			  $_[1]->[$i+1] - $_[1]->[$i] - 2);
	$w =~ s/^\s+//;
	$w =~ s/\s+$//;
	push(@rv, $w);
	}
return @rv;
}

sub can_edit_db
{
local $d;
return 1 if ($access{'dbs'} eq '*');
foreach $d (split(/\s+/, $access{'dbs'})) {
	return 1 if ($d eq $_[0]);
	}
return 0;
}

1;

