#!/usr/local/bin/perl
# edit_mount.cgi
# Display a form for editing or creating a permanent or temporary mounting.

require './mount-lib.pl';
&error_setup($text{'edit_err'});
&ReadParse();
if (defined($in{index})) {
	if ($in{temp}) {
		# Edit a temporary mount, existing only in the mnttab
		@mlist = &list_mounted();
		@minfo = @{$mlist[$in{index}]};
		$mnow = 1; $msave = 0;
		}
	else {
		# Edit a permanent mount, which may or may not be currently
		# mounted.
		@mlist = &list_mounts();
		@minfo = @{$mlist[$in{index}]};
		$msave = 1; $mnow = (&get_mounted($minfo[0], $minfo[1]) >= 0);
		}
	if ($in{index} >= @mlist) {
		&error($text{'edit_egone'});
		}
	$type = $minfo[2];
	&header($text{'edit_title'}, "");
	print "<hr>\n";
	$newm = 0;
	}
else {
	# creating a new mount (temporary or permanent)
	$type = $in{type};
	&header($text{'create_title'}, "");
	print "<hr>\n";
	$newm = 1;
	}
@mmodes = &mount_modes($type);
$msave = ($mmodes[0]==0 ? 0 : $msave);
$mnow = ($mmodes[1]==0 ? $msave : $mnow);

print "<form action=\"save_mount.cgi\">\n";
print "<input name=return type=hidden value='$in{'return'}'>\n";
if (!$newm) {
	print "<input type=hidden name=old value=\"$in{index}\">\n";
	print "<input type=hidden name=temp value=\"$in{temp}\">\n";

	print "<input type=hidden name=oldmnow value=$mnow>\n";
	print "<input type=hidden name=oldmsave value=$msave>\n";
	}
print "<input type=hidden name=type value=\"$type\">\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>",&text('edit_header', &fstype_name($type)),
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'edit_dir'}</b></td>\n";
if ($type eq "swap") {
	print "<td colspan=3><i>$text{'edit_swap'}</i></b>\n";
	}
else {
	print "<td colspan=3><input size=30 name=directory value=\"$minfo[0]\">\n";
	print &file_chooser_button("directory", 1);
	}
if (!$newm && (($size,$free) = &disk_space($type, $minfo[0]))) {
	print "&nbsp;" x 8;
	printf "<b>$text{'edit_size'}</b> <i>%d Kb</i> / \n", $size;
	printf "<b>$text{'edit_free'}</b> <i>%d Kb</i></td>\n", $free;
	}
print "</td> </tr>\n";

if ($mmodes[0] != 0) {
	print "<tr> <td><b>$text{'edit_savemount'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=msave value=2 %s> $text{'edit_boot'}\n",
		$minfo[5] eq "yes" || $newm ? "checked" : "";
	if ($mmodes[0] != 1) {
		printf "<input type=radio name=msave value=1 %s> %s\n",
			$minfo[5] eq "no" ? "checked" : "", $text{'edit_save'};
		}
	if (!$newm && $mmodes[1] == 0) {
		printf "<input type=radio name=msave value=0 %s> %s\n",
			$minfo[5] eq "" && !$newm ? "checked" : "",
			$text{'edit_delete'};
		}
	else {
		printf "<input type=radio name=msave value=0 %s> %s\n",
			$minfo[5] eq "" && !$newm ? "checked" : "",
			$text{'edit_dont'};
		}
	print "</td> </tr>\n";
	}
if ($mmodes[1] == 1 && ($mmodes[3] == 0 || !$mnow)) {
	print "<tr> <td><b>$text{'edit_now'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=mmount value=1 %s> %s\n",
		$mnow || $newm ? "checked" : "", $text{'edit_mount'};
	if ($mmodes[0] == 0) {
		printf "<input type=radio name=mmount value=0 %s> %s\n",
			$mnow || $newm ? "" : "checked", $text{'edit_delete'};
		}
	else {
		printf "<input type=radio name=mmount value=0 %s> %s\n",
			$mnow || $newm ? "" : "checked",
			$newm ? $text{'edit_dont2'} : $text{'edit_unmount'};
		}
	print "</td> </tr>\n";
	}

if ($mmodes[2]) {
	print "<tr> <td><b>$text{'edit_order'}</b></td>\n";
	printf "<td colspan=3><input type=radio name=order value=0 %s> %s\n",
		$newm || $minfo[4] == 0 ? "checked" : "", $text{'no'};
	printf "<input type=radio name=order value=1 %s> %s\n",
		$minfo[4] == 1 ? "checked" : "", $text{'edit_first'};
	printf "<input type=radio name=order value=%s %s> %s</td\n",
		$minfo[4] > 1 ? $minfo[4] : 2 , $minfo[4] > 1 ? "checked" : "",
		$text{'edit_second'};
	print "</tr>\n";
	}
&generate_location($type, $minfo[1]);
print "</table></td> </tr></table><p>\n";

# generate mount options
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_adv'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
&parse_options($type, $minfo[3]);
&generate_options($type, $newm);
print "</table></td> </tr></table>\n";

if ($newm) {
	print "<p><input type=submit value=\"$text{'create'}\"></form><p>\n";
	}
elsif ($mnow && $minfo[2] ne "swap") {
	print "<table width=100%><tr><td>\n";
	print "<input type=submit value=\"$text{'save'}\"></td>\n";
	print "</form><form action=../proc/index_search.cgi>\n";
	print "<input type=hidden name=mode value=3>\n";
	print "<input type=hidden name=fs value=$minfo[0]>\n";
	print "<td align=right><input type=submit ",
	      "value=\"$text{'edit_list'}\">\n";
	print "</td></tr></table></form>\n";
	}
else {
	print "<p><input type=submit value=\"$text{'save'}\"></form><p>\n";
	}
print "<hr>\n";
&footer($in{'return'}, $text{'index_return'});

