#!/usr/local/bin/perl
# index.cgi
# Display all the boot partitions

require './lilo-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

# Check for non-intel architecture
if (`uname -m 2>&1` !~ /i.86/i) {
	print "<p><b>$text{'index_earch'}</b><p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

$conf = &get_lilo_conf();
@images = sort { $a->{'index'} <=> $b->{'index'} }
	       ( &find("image", $conf), &find("other", $conf) );

$default = &find_value("default", $conf);
foreach $i (@images) {
	local $n = $i->{'name'};
	push(@icons, $n eq "image" ? "images/image.gif" : "images/other.gif");
	$l = &find_value("label", $i->{'members'});
	push(@titles, !$default && $i eq $images[0] ? "<b>$l</b>" :
		      $default && $default eq $l ? "<b>$l</b>" : $l);
	push(@links, "edit_$n.cgi?idx=$i->{'index'}");
	}
&icons_table(\@links, \@titles, \@icons, 4);
print "<a href='edit_image.cgi?new=1'>$text{'index_addk'}</a> &nbsp;\n";
print "<a href='edit_other.cgi?new=1'>$text{'index_addp'}</a><p>\n";
print "<hr>\n";

print "<table width=100%>\n";
print "<form action=edit_global.cgi>\n";
print "<tr><td><input type=submit value=\"$text{'index_global'}\"></td>\n";
print "<td>$text{'index_globalmsg'}</td></tr></form>\n";

%flang = &load_language('fdisk');
$text{'select_part'} = $flang{'select_part'};
$text{'select_device'} = $flang{'select_device'};
$text{'select_fd'} = $flang{'select_fd'};
$dev = &find_value("boot", $conf);
print "<form action=apply.cgi>\n";
print "<tr><td><input type=submit value=\"$text{'index_apply'}\"></td> <td>\n";
if ($dev) {
	print &text('index_applymsg1',
	  $dev =~ /fd(\d+)$/ ? &text('select_fd', $1) :
	  $dev =~ /hd([a-z])(\d+)$/ ? &text('select_part', 'IDE', uc($1), $2) :
	  $dev =~ /sd([a-z])(\d+)$/ ? &text('select_part', 'SCSI', uc($1), $2) :
	  $dev =~ /hd([a-z])$/ ? &text('select_device', 'IDE', uc($1)) :
	  $dev =~ /sd([a-z])$/ ? &text('select_device', 'SCSI', uc($1)) : $dev);
	}
else {
	print $text{'index_applymsg2'};
	}
print "\n",$text{'index_applymsg3'},"</td></tr></form>\n";
print "</table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

