#!/usr/local/bin/perl

require "./inittab-lib.pl";

&ReadParse();

&error( $text{ 'save_inittab_err' } ) if( !$access{ 'inittab' } );
&error( $text{ 'save_inittab_noid' } ) if( !$in{ 'id' } );

&lock_file($config{ 'inittab_file' });
local $file = &read_file_lines( $config{ 'inittab_file' } ), $number = -1, $i = 0;

foreach ( @{ $file } )
{
    $line = $_;
    $line =~ s/\r|\n//g;
    $line =~ s/#.*$//g;
    $line =~ s/\/\/.*$//g;

    if( $_ )
    {
        local ( $id ) = split( /:/ );
        $number = $i if( $id eq $in{ 'oldid' } );

	if( $in{ 'id' } ne $in{ 'oldid' } && $id eq $in{ 'id' } )
	{
	    &error( $text{ 'save_inittab_already' } );
	}
    }
    $i++;
}

if( $in{ 'button' } eq $text{ 'edit_inittab_del' } )
{
    splice( @$file, $number, 1 );
} elsif( $in{ 'button' } eq $text{ 'edit_inittab_save' } )
{
    local $new = $in{ 'id' }. ":";
    foreach ( 0..6, "a", "b", "c" )
    {
	$new .= $_ if( $in{ $_ } eq "1" );
    }
    $new .= ":". $in{ 'action' }. ":". $in{ 'process' };

    if( $number == -1 )
    {
	push( @$file, $new );
    }
    else
    {
	$file -> [$number] = $new;
    }
}

&flush_file_lines();
&unlock_file($config{ 'inittab_file' });
if ( $in{ 'button' } eq $text{ 'edit_inittab_del' }) {
	&webmin_log("delete", "inittab", $in{ 'oldid' }, \%in);
	}
elsif ( $number == -1 ) {
	&webmin_log("create", "inittab", $in{ 'id' }, \%in);
	}
else {
	&webmin_log("modify", "inittab", $in{ 'id' }, \%in);
	}

&redirect( "/inittab/index.cgi" );
