#!/usr/local/bin/perl
# index.cgi
# Display a list of run-levels and the actions that are run at boot and
# shutdown time for each level

require './inittab-lib.pl';
&header( $text{'inittab_title'}, "", "index", 1, 1, undef );
%access = &get_module_acl();

print(
"<p><hr><p><table border width=\"100%\">",
  "<tr ", $tb, ">",
	"<td><b>", &hlink( $text{ 'inittab_id' }, "id" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_runlevels' }, "runlevels" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_action' }, "action" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_process' }, "process" ), "</b></td>",
  "</tr>" );

open( INITTAB, $config{ 'inittab_file' } );
foreach ( <INITTAB> )
{
  s/\r|\n//g;
  s/#.*$//g;
  s/\/\/.*$//g;

  if( $_ )
  {
	local ( $id, $raw_runlevels, $action, $process ) = split( /:/ ), $runlevels = "";
	$process = $text{ 'inittab_none' } if( !$process );
    if( $raw_runlevels )
	{
	  foreach $runlevel ( split( //, $raw_runlevels ) )
	  {
		    $runlevels .= $runlevel. ", ";
	  }
	  chop( $runlevels ); chop( $runlevels );
	} else {
	  $runlevels = $text{ 'inittab_none' };
	}

	$action = "kbdrequest" if ($action eq "kbrequest");
	$action = "inittab_". $action;
	print(
  "<tr ", $cb, ">",
	"<td><a href=\"edit_inittab.cgi?id=", $id, "\">", $id, "</a></td>",
	"<td>", $runlevels, "</td>",
	"<td>", $text{ $action }, "</td>",
	"<td>", $process, "</td>",
  "</tr>" );
  }
}
print(
"</table>",
"<a href=new_inittab.cgi>", $text{ 'inittab_new' }, "</a><p><hr>" );

&footer( "/", $text{'index'} );
