# log_parser.pl
# Functions for parsing this module's logs

require './file-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p) = @_;
if ($type eq 'export' || $type eq 'share') {
	return &text("log_${action}_${type}", "<tt>$object</tt>");
	}
elsif ($action eq 'save' || $action eq 'chmod' || $action eq 'mkdir' ||
       $action eq 'upload' || $action eq 'delete') {
	return &text("log_${action}", "<tt>$object</tt>");
	}
elsif ($action eq 'link' || $action eq 'move' || $action eq 'copy') {
	return &text("log_${action}",
		     "<tt>$object</tt>", "<tt>$p->{'to'}</tt>");
	}
elsif ($action eq 'relink') {
	return &text('log_relink',
		     "<tt>$object</tt>", "<tt>$p->{'linkto'}</tt>");
	}
elsif ($action eq 'rename') {
	return &text('log_move', "<tt>$object</tt>", "<tt>$p->{'new'}</tt>");
	}
else {
	return undef;
	}
}

