#!/usr/local/bin/perl
# save_export.cgi
# Save, create or delete an export

require './exports-lib.pl';
&ReadParse();
&lock_file($config{'exports_file'});
@exps = &list_exports();

if ($in{'delete'}) {
	# Deleting some export
	$exp = $exps[$in{'idx'}];
	&delete_export($exp);
	}
else {
	if (!$in{'new'}) {
		# Get old export
		$oldexp = $exps[$in{'idx'}];
		%opts = %{$oldexp->{'options'}};
		}

	# Validate and parse inputs
	&error_setup($text{'save_err'});
	-d $in{'dir'} || &error(&text('save_edir', $in{'dir'}));
	$exp{'dir'} = $in{'dir'};
	$exp{'active'} = $in{'active'};

	if ($in{'mode'} == 0) { $exp{'host'} = "=public"; }
	elsif ($in{'mode'} == 1) {
		$in{'netgroup'} =~ /^\S+$/ ||
			&error($text{'save_enetgroup'});
		$exp{'host'} = '@'.$in{'netgroup'};
		}
	elsif ($in{'mode'} == 2) {
		&check_ipaddress($in{'network'}) ||
			&error(&text('save_enetwork', $in{'network'}));
		&check_ipaddress($in{'netmask'}) ||
			&error(&text('save_enetmask', $in{'netmask'}));
		$exp{'host'} = $in{'network'}."/".$in{'netmask'};
		}
	elsif ($in{'mode'} == 3) { $exp{'host'} = ""; }
	else {
		$in{'host'} =~ /\*/ || gethostbyname($in{'host'}) ||
			&error(&text('save_ehost', $in{'host'}));
		$exp{'host'} = $in{'host'};
		}

	# validate and parse options
	delete($opts{'link_relative'}); delete($opts{'link_absolute'}); 
	$opts{'link_relative'} = "" if ($in{'link_relative'});

	delete($opts{'secure'}); delete($opts{'insecure'});
	$opts{'insecure'} = "" if ($in{'insecure'});

	if ($in{'ro'}) {
		delete($opts{'rw'});
		$opts{'ro'} = '';
		}
	else {
		delete($opts{'ro'});
		$opts{'rw'} = '';
		}

	delete($opts{'noaccess'});
	$opts{'noaccess'} = "" if ($in{'noaccess'});

	delete($opts{'root_squash'}); delete($opts{'no_root_squash'});
	delete($opts{'all_squash'}); delete($opts{'no_all_squash'});
	$opts{'no_root_squash'} = "" if ($in{'squash'} == 0);
	$opts{'all_squash'} = "" if ($in{'squash'} == 2);

	if ($in{'squash_uids_def'}) { delete($opts{'squash_uids'}); }
	elsif ($in{'squash_uids'} !~ /^[\d+\-\,]+$/) {
		&error($text{'save_euids'});
		}
	else { $opts{'squash_uids'} = $in{'squash_uids'}; }

	if ($in{'squash_gids_def'}) { delete($opts{'squash_gids'}); }
	elsif ($in{'squash_gids'} !~ /^[\d+\-\,]+$/) {
		&error($text{'save_egids'});
		}
	else { $opts{'squash_gids'} = $in{'squash_gids'}; }

	if ($in{'anonuid_def'}) { delete($opts{'anonuid'}); }
	elsif ($in{'anonuid'} =~ /^[0-9\-]+$/)
		{ $opts{'anonuid'} = $in{'anonuid'}; }
	else { $opts{'anonuid'} = getpwnam($in{'anonuid'}); }

	if ($in{'anongid_def'}) { delete($opts{'anongid'}); }
	elsif ($in{'anongid'} =~ /^[0-9\-]+$/)
		{ $opts{'anongid'} = $in{'anongid'}; }
	else { $opts{'anongid'} = getgrnam($in{'anongid'}); }

	$exp{'options'} = \%opts;
	if ($in{'new'}) {
		&create_export(\%exp);
		}
	else {
		&modify_export(\%exp, $oldexp);
		}
	}
&unlock_file($config{'exports_file'});
if ($in{'delete'}) {
	&webmin_log("delete", "export", $exp->{'dir'}, $exp);
	}
elsif ($in{'new'}) {
	&webmin_log("create", "export", $exp{'dir'}, \%exp);
	}
else {
	&webmin_log("modify", "export", $exp{'dir'}, \%exp);
	}
&redirect("");

