#!/usr/local/bin/perl
# save_subnet.cgi
# Update, create or delete a subnet

require './dhcpd-lib.pl';
require './params-lib.pl';
&ReadParse();
&lock_file($config{'dhcpd_conf'});
$parent = &get_parent_config();
$conf = $parent->{'members'};
if ($in{'delete'}) {
	# Delete this subnet
	$whatfailed = $text{'ssub_faildel'};
	if ($in{'sidx'} ne "") {
		# deleting from within shared net
		$sha = $conf->[$in{'sidx'}];
		$sub = $sha->{'members'}->[$in{'idx'}];
		&save_directive($sha, [ $sub ], [ ], 0);
		}
	else {
		# deleting from top level
		$sub = $conf->[$in{'idx'}];
		&save_directive($parent, [ $sub ], [ ], 0);
		}
	}
elsif ($in{'options'}) {
	# Redirect to client options
	&redirect("edit_options.cgi?pidx=$in{'sidx'}&idx=$in{'idx'}");
	exit;
	}
else {
	$whatfailed = $text{'ssub_failsave'};
	if (!$in{'new'}) {
		# Get the old subnet structure
		if ($in{'sidx'} ne "") {
			$sha = $conf->[$in{'sidx'}];
			$sub = $sha->{'members'}->[$in{'idx'}];
			}
		else { $sub = $conf->[$in{'idx'}]; }
		}
	else {
		# Creating a new structure
		$sub->{'name'} = "subnet";
		$sub->{'type'} = 1;
		$sub->{'members'} = [ ];
		}

	# Validate and save inputs
	gethostbyname($in{'network'}) || &check_ipaddress($in{'network'}) ||
		&error("'$in{'network'}' $text{'ssub_invalidsubaddr'}");
	&check_ipaddress($in{'netmask'}) ||
		&error("'$in{'netmask'}' $text{'ssub_invalidnmask'}");
	$sub->{'values'} = [ $in{'network'}, "netmask", $in{'netmask'} ];

	for($i=0; defined($low = $in{"range_low_$i"}); $i++) {
		next if (!$low);
		$hi = $in{"range_hi_$i"}; $dyn = $in{"range_dyn_$i"};
		&check_ipaddress($low) ||
			&error("'$low' $text{'ssub_invalidipr'}");
		!$hi || &check_ipaddress($hi) ||
			&error("'$hi' $text{'ssub_invalidipr'}");
		$rng = { 'name' => 'range',
			 'values' => [ ($dyn ? "dynamic-bootp" : ()),
				       $low, ($hi ? $hi : ()) ] };
		push(@rng, $rng);
		}
	&save_directive($sub, "range", \@rng, 1);
	&parse_params($sub, 0);

	@subn = &find("subnet", $conf);
	if ($in{'new'}) {
		if ($in{'shared'} ne "") {
			# Add to a shared network block
			&save_directive($conf->[$in{'shared'}],
					[ ], [ $sub ], 1);
			}
		else {
			# Add to the end of the file
			&save_directive($parent, [ ], [ $sub ], 0);
			}
		}
	else {
		if ($in{'shared'} ne "" && $sha) {
			local $nsha = $conf->[$in{'shared'}];
			if ($nsha->{'index'} == $sha->{'index'}) {
				# Updating within shared network block
				&save_directive($sha, [ $sub ], [ $sub ], 1);
				}
			else {
				# Moving from one shared block to another
				&save_directive($sha, [ $sub ], [ ], 0);
				&save_directive($nsha, [ ], [ $sub ], 1);
				}
			}
		elsif ($in{'shared'} ne "") {
			# Moving into shared network block
			local $nsha = $conf->[$in{'shared'}];
			&save_directive($parent, [ $sub ], [ ], 0);
			&save_directive($nsha, [ ], [ $sub ], 1);
			}
		elsif ($sha) {
			# Moving out of shared network block
			&save_directive($sha, [ $sub ], [ ], 0);
			&save_directive($parent, [ ], [ $sub ], 0);
			}
		else {
			# Updating outside shared network
			&save_directive($parent, [ $sub ], [ $sub ], 0);
			}
		}
	}
&flush_file_lines();
&unlock_file($config{'dhcpd_conf'});
&webmin_log($in{'delete'} ? 'delete' : $in{'new'} ? 'create' : 'modify',
	    'subnet', "$sub->{'values'}->[0]/$sub->{'values'}->[2]", \%in);
&redirect("");


