#!/usr/local/bin/perl
# save_options.cgi
# Save client options for some subnet, shared net, group, host or global

require './dhcpd-lib.pl';
&ReadParse();
&lock_file($config{'dhcpd_conf'});
$conf = &get_config();
if ($in{'pidx'} ne "") {
	$client = $conf->[$in{'pidx'}]->{'members'}->[$in{'idx'}];
	$indent = 2;
	}
elsif ($in{'idx'} ne "") {
	$client = $conf->[$in{'idx'}];
	$indent = 1;
	}
else {
	$client = &get_parent_config();
	$indent = 0;
	}
$whatfailed = $text{'sopt_failsave'};

&save_option("host-name", 3, $client, $indent);
&save_option("routers", 2, $client, $indent);
&save_option("subnet-mask", 0, $client, $indent);
&save_option("broadcast-address", 0, $client, $indent);
&save_option("domain-name", 3, $client, $indent);
&save_option("domain-name-servers", 2, $client, $indent);
&save_option("time-servers", 2, $client, $indent);
&save_option("log-servers", 2, $client, $indent);
&save_option("swap-server", 2, $client, $indent);
&save_option("root-path", 3, $client, $indent);
&save_option("nis-domain", 3, $client, $indent);
&save_option("nis-servers", 2, $client, $indent);
&save_option("font-servers", 2, $client, $indent);
&save_option("x-display-manager", 2, $client, $indent);
&save_option("static-routes", 5, $client, $indent);
&save_option("ntp-servers", 2, $client, $indent);
&save_option("netbios-name-servers", 2, $client, $indent);
&save_option("netbios-scope", 3, $client, $indent);
&save_option("netbios-node-type", 1, $client, $indent);
&flush_file_lines();
&unlock_file($config{'dhcpd_conf'});
if ($client->{'name'} eq 'subnet') {
	&webmin_log("options", 'subnet',
		    "$client->{'values'}->[0]/$client->{'values'}->[2]", \%in);
	}
elsif ($client->{'name'} eq 'shared-network') {
	&webmin_log("options", 'subnet', $client->{'values'}->[0], \%in);
	}
elsif ($client->{'name'} eq 'host') {
	&webmin_log("options", 'host', $client->{'values'}->[0], \%in);
	}
elsif ($client->{'name'} eq 'group') {
	@count = &find("host", $client->{'members'});
	&webmin_log("options", 'group',
		    join(",", map { $_->{'values'}->[0] } @count), \%in);
	}
&redirect("");

# save_option(name, type, &config, indent)
sub save_option
{
local($v);
local $m = $_[2]->{'members'};
for($i=0; $i<@$m; $i++) {
	if ($m->[$i]->{'name'} eq 'option' &&
	    $m->[$i]->{'values'}->[0] eq $_[0]) {
		$v = $m->[$i];
		last;
		}
	}
if ($in{"$_[0]_def"}) {
	&save_directive($_[2], [ $v ], [ ], 0, 1) if ($v);
	}
else {
	local $nv = $in{$_[0]};
	local @nv = split(/\s+/, $nv);
	if ($_[1] == 0) {
		gethostbyname($nv) || &check_ipaddress($nv) ||
			&error("'$nv' $text{'sopt_invalidip'}");
		}
	elsif ($_[1] == 1) {
		$nv =~ /^\d+$/ || &error("'$nv' $text{'sopt_invalidint'}");
		}
	elsif ($_[1] == 2) {
		local $ip;
		foreach $ip (@nv) {
			gethostbyname($ip) || &check_ipaddress($ip) ||
				&error("'$ip' $text{'sopt_invalidip'}");
			}
		$nv = join(" , ", @nv);
		}
	elsif ($_[1] == 3) {
		$nv = "\"$nv\"";
		}
	elsif ($_[1] == 5) {
		local($ipp, @nnv);
		foreach $ipp (@nv) {
			$ipp =~ /^(\S+)\s*,\s*(\S+)$/ ||
				&error("'$ipp' $text{'sopt_invalidipp'}");
			&check_ipaddress($1) ||
				&error("'$1' $text{'sopt_invalidip'}");
			&check_ipaddress($2) ||
				&error("'$2' $text{'sopt_invalidip'}");
			push(@nnv, "$1 $2");
			}
		$nv = join(" , ", @nnv);
		}
	local $dir = { 'name' => 'option',
		       'values' => [ $_[0], $nv ] };
	&save_directive($_[2], $v ? [ $v ] : [ ], [ $dir ], $_[3], 1);
	}
}

