# custom-lib.pl
# Functions for storing custom commands

do '../web-lib.pl';
&init_config();
%access = &get_module_acl();

# list_commands()
# Returns a list of all custom commands
sub list_commands
{
local (@rv, $f);
opendir(DIR, $module_config_directory);
while($f = readdir(DIR)) {
	if ($f =~ /^(\d+)\.cmd$/) {
		local %cmd;
		$cmd{'file'} = "$module_config_directory/$f";
		$cmd{'id'} = $1;
		open(FILE, $cmd{'file'});
		chop($cmd{'cmd'} = <FILE>);
		chop($cmd{'desc'} = <FILE>);
		local @o = split(/\s+/, <FILE>);
		$cmd{'user'} = $o[0];
		$cmd{'raw'} = int($o[1]);
		$cmd{'su'} = int($o[2]);
		while(<FILE>) {
			s/\r|\n//g;
			local @a = split(/:/, $_, 5);
			push(@{$cmd{'args'}}, { 'name' => $a[0],
						'type' => $a[1],
						'opts' => $a[2],
						'quote' => $a[3],
						'desc' => $a[4] });
			}
		close(FILE);
		$cmd{'index'} = scalar(@rv);
		push(@rv, \%cmd);
		}
	}
closedir(DIR);
return @rv;
}

# save_command(&command)
sub save_command
{
local $c = $_[0];
local $a;
&lock_file("$module_config_directory/$c->{'id'}.cmd");
open(FILE, ">$module_config_directory/$c->{'id'}.cmd");
print FILE $c->{'cmd'},"\n";
print FILE $c->{'desc'},"\n";
print FILE $c->{'user'}," ",$c->{'raw'}," ",$c->{'su'},"\n";
foreach $a (@{$c->{'args'}}) {
	print FILE $a->{'name'},":",$a->{'type'},":",
		   $a->{'opts'},":",$a->{'quote'},":",$a->{'desc'},"\n";
	}
close(FILE);
&unlock_file("$module_config_directory/$c->{'id'}.cmd");
}

# delete_command(&command)
sub delete_command
{
local $c = $_[0];
&lock_file("$module_config_directory/$c->{'id'}.cmd");
unlink("$module_config_directory/$c->{'id'}.cmd");
&unlock_file("$module_config_directory/$c->{'id'}.cmd");
}

sub can_run_command
{
local $c;
foreach $c (split(/\s+/, $access{'cmds'})) {
	return 1 if ($c eq "*" || $c == $_[0]->{'id'});
	}
return 0;
}

1;
