#!/usr/local/bin/perl
# save_cron.cgi
# Save an existing cron job, or create a new one

require './cron-lib.pl';
&error_setup($text{'save_err'});
&ReadParse();

@jobs = &list_cron_jobs();
if ($in{'new'}) {
	$job = { 'type' => 0 };
	}
else {
	$oldjob = $jobs[$in{'idx'}];
	$job->{'type'} = $oldjob->{'type'};
	$job->{'file'} = $oldjob->{'file'};
	$job->{'line'} = $oldjob->{'line'};
	$job->{'nolog'} = $oldjob->{'nolog'};
	}

@files = &unique((map { $_->{'file'} } @jobs),
	         "$config{'cron_dir'}/$in{'user'}");
foreach $f (@files) { &lock_file($f); }

# Check and parse inputs
if ($in{"cmd"} !~ /\S/) {
	&error($text{'save_ecmd'});
	}
if (!$in{"user"}) {
	&error($text{'save_euser'});
	}
foreach $arr ("mins", "hours", "days", "months", "weekdays") {
	if ($in{"all_$arr"}) {
		# All mins/hrs/etc.. chosen
		$job->{$arr} = "*";
		}
	elsif (defined($in{$arr})) {
		# Need to work out and simplify ranges selected
		undef(@range);
		undef(@newrange);
		@range = split(/\0/, $in{$arr});
		@range = sort { $a <=> $b } @range;
		$start = -1;
		for($i=0; $i<@range; $i++) {
			if ($i && $range[$i]-1 == $range[$i-1]) {
				# ok.. looks like a range
				if ($start < 0) { $start = $i-1; }
				}
			elsif ($start < 0) {
				# Not in a range at all
				push(@newrange, $range[$i]);
				}
			else {
				# End of the range.. add it
				$newrange[@newrange - 1] =
					"$range[$start]-".$range[$i-1];
				push(@newrange, $range[$i]);
				$start = -1;
				}
			}
		if ($start >= 0) {
			# Reached the end while in a range
			$newrange[@newrange - 1] =
				"$range[$start]-".$range[$i-1];
			}
		$job->{$arr} = join(',' , @newrange);
		}
	else {
		&error(&text('save_enone', $text{"edit_$arr"}));
		}
	}
$in{input} =~ s/\r//g; $in{input} =~ s/%/\\%/g;
$in{cmd} =~ s/%/\\%/g;
$job->{'active'} = $in{'active'};
$job->{'command'} = $in{'cmd'};
if ($in{input} =~ /\S/) {
	@inlines = split(/\n/ , $in{input});
	$job->{'command'} .= '%'.join('%' , @inlines);
	}

# Check if this user is allowed to execute cron jobs
if (-r $config{cron_allow_file}) {
	if (&indexof($in{user}, &list_allowed()) < 0) { $err = 1; }
	}
elsif (-r $config{cron_deny_file}) {
	if (&indexof($in{user}, &list_denied()) >= 0) { $err = 1; }
	}
elsif ($config{cron_deny_all} == 0) { $err = 1; }
elsif ($config{cron_deny_all} == 1) {
	if ($in{user} ne "root") { $err = 1; }
	}
if ($err) { &error(&text('save_eallow', $in{'user'})); }
$job->{'user'} = $in{'user'};

# Check module access control
%access = &get_module_acl();
&can_edit_user(\%access, $in{'user'}) ||
	&error(&text('save_ecannot', $in{'user'}));

if (!$in{'new'}) {
	# Editing an existing job
	&can_edit_user(\%access, $in{'olduser'}) ||
		&error(&text('save_ecannot', $in{'olduser'}));
	if ($job->{'user'} eq $oldjob->{'user'}) {
		&change_cron_job($job);
		}
	else {
		&delete_cron_job($oldjob);
		&create_cron_job($job);
		}
	}
else {
	# Creating a new job
	&create_cron_job($job);
	}

foreach $f (@files) { &unlock_file($f); }
if ($in{'new'}) {
	&webmin_log("create", "cron", $in{'user'}, \%in);
	}
else {
	&webmin_log("modify", "cron", $in{'user'}, \%in);
	}
&redirect("");


