#!/usr/local/bin/perl
# config.cgi
# Display a form for editing the configuration of a module.
# Each module has a number of configurable parameters (stored in the file
# config.txt in the module directory). Descriptions and possible values for
# each option are stored in the file config.info in the module directory.
# Each line of config.info looks like
# name=desc,type[,options]
#  desc - A description of the parameter
#  type - Possible types (and options) are
#	0 - Free text
#	1 - One of many (options are possibles)
#	2 - Many of many (options are possibles)
#	3 - Optional free text
#	4 - Like 1, but uses a pulldown menu
#	5 - User name
#	6 - Group name
#	7 - Directory
#	8 - File
#	9 - Multiline text

require './web-lib.pl';
&init_config();
$m = $ARGV[0];
%access = &get_module_acl(undef, $m);
$access{'noconfig'} &&
	&error($text{'config_ecannot'});
%module_info = &get_module_info($m);
&header($text{'config_title'}, "", undef, 0, 1);
print "<center><font size=+2>",&text('config_dir', $module_info{'desc'}),
      "</font></center>\n";
print "<hr>\n";

&read_file("$m/config.info", \%info, \@info_order);
&read_file("$m/config.info.$current_lang", \%info, \@info_order);
@info_order = &unique(@info_order);
&read_file("$config_directory/$m/config", \%config);

print "<form action=\"config_save.cgi\">\n";
print "<input type=hidden name=module value=\"$m\">\n";
print "<table width=100% border>\n";
print "<tr $tb> <td><b>",&text('config_header', $module_info{'desc'}),
      "</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
foreach $c (@info_order) {
	@p = split(/,/, $info{$c});
	print "<tr> <td valign=top><b>$p[0]</b></td>\n";
	print "<td nowrap>\n";
	$qw = $config{$c} =~ /'/ ? '"' : "'";
	if ($p[1] == 0) {
		$size = $p[2] ? "size=$p[2]" : "size=40";
		$max = $p[3] ? "maxlength=$p[3]" : "";
		print "<input name=\"$c\" $size $max value=$qw$config{$c}$qw>\n";
		}
	elsif ($p[1] == 1) {
		for($i=2; $i<@p; $i++) {
			$p[$i] =~ /^(\S+)\-(.*)$/;
			printf "<input type=radio name=\"$c\" value=$1 %s>\n",
				$config{$c} eq $1 ? "checked" : "";
			print "$2 &nbsp;&nbsp;\n";
			}
		}
	elsif ($p[1] == 2) {
		local %sel;
		map { $sel{$_}++ } split(/,/, $config{$c});
		print "<select name=\"$c\" size=4 multiple>\n";
		for($i=2; $i<@p; $i++) {
			$p[$i] =~ /^(\S+)\-(.*)$/;
			printf "<option value=\"$1\" %s>$2\n",
				$sel{$1} ? "selected" : "";
			}
		print "</select>\n";
		}
	elsif ($p[1] == 3) {
		$none = $p[2] ? $p[2] : $text{'config_none'};
		printf "<input type=radio name=\"%s_none\" value=1 %s> $none\n",
			$c, $config{$c} eq "" ? "checked" : "";
		print "&nbsp;&nbsp;\n";
		printf "<input type=radio name=\"%s_none\" value=0 %s>\n",
			$c, $config{$c} eq "" ? "" : "checked";
		print "<input name=\"$c\" size=20 value=$qw$config{$c}$qw>\n";
		}
	elsif ($p[1] == 4) {
		print "<select name=\"$c\">\n";
		for($i=2; $i<@p; $i++) {
			$p[$i] =~ /^(\S+)\-(.*)$/;
			printf "<option value=\"$1\" %s>$2\n",
				$config{$c} eq $1 ? "selected" : "";
			}
		print "</select>\n";
		}
	elsif ($p[1] == 5) {
		if ($p[2]) {
			printf
			   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
			   $config{$c} eq "" ? "checked" : "";
			printf "<input type=radio name=${c}_def value=0 %s>\n",
			   $config{$c} eq "" ? "" : "checked";
			}
		print &unix_user_input($c, $config{$c});
		}
	elsif ($p[1] == 6) {
		if ($p[2]) {
			printf
			   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
			   $config{$c} eq "" ? "checked" : "";
			printf "<input type=radio name=${c}_def value=0 %s>\n",
			   $config{$c} eq "" ? "" : "checked";
			}
		print &unix_group_input($c, $config{$c});
		}
	elsif ($p[1] == 7) {
		print "<input name=\"$c\" size=40 value=$qw$config{$c}$qw> ",
		      &file_chooser_button($c, 1);
		}
	elsif ($p[1] == 8) {
		print "<input name=\"$c\" size=40 value=$qw$config{$c}$qw> ",
		      &file_chooser_button($c, 0);
		}
	elsif ($p[1] == 9) {
		local $cols = $p[2] ? $p[2] : 40;
		local $rows = $p[3] ? $p[3] : 5;
		print "<textarea name=\"$c\" rows=$rows cols=$cols>",
			join("\n", split(/\s+/, $config{$c})),
			"</textarea>\n";
		}
	print "</td> </tr>\n";
	}
print "</table></td></tr></table>\n";
print "<input type=submit value=\"$text{'save'}\"></form>\n";
print "<hr>\n";
&footer("/$m", $text{'index'});

