#!/usr/local/bin/perl
# edit_master.cgi
# Display options and directives in an existing master zone

require './bind8-lib.pl';
&ReadParse();
$conf = &get_config();
$zconf = $conf->[$in{'index'}]->{'members'};
$dom = $conf->[$in{'index'}]->{'value'};
%access = &get_module_acl();
&can_edit_zone(\%access, $dom) || &error($text{'master_ecannot'});
&header($text{'master_title'}, "");
print "<center><font size=+2>",&arpa_to_ip($dom),"</font></center>\n";

print "<hr><p>\n";
@recs = &read_zone_file(&find("file", $zconf)->{'value'}, $dom);
if ($dom =~ /in-addr.arpa/i) {
	@rcodes = ("PTR", "NS");
	}
else {
	@rcodes = ("A", "NS", "CNAME", "MX", "HINFO", "TXT", "WKS", "RP");
	}
foreach $c (@rcodes) { $rnum{$c} = 0; }
foreach $r (@recs) {
	$rnum{$r->{'type'}}++;
	if ($r->{'type'} eq "SOA") { $soa = $r; }
	}
if ($config{'show_list'}) {
	# display as list
	$mid = int((@rcodes+1)/2);
	print "<table width=100%> <tr><td width=50%>\n";
	&types_table(@rcodes[0..$mid-1]);
	print "</td><td width=50%>\n";
	&types_table(@rcodes[$mid..$#rcodes]);
	print "</td></tr> </table>\n";
	}
else {
	# display as icons
	for($i=0; $i<@rcodes; $i++) {
		push(@rlinks,
		     "edit_recs.cgi?index=$in{'index'}&type=$rcodes[$i]");
		push(@rtitles, $text{"type_$rcodes[$i]"}.
			       " ($rnum{$rcodes[$i]})");
		push(@ricons, "images/$rcodes[$i].gif");
		}
	&icons_table(\@rlinks, \@rtitles, \@ricons);
	}
$file = &absolute_path(&find("file", $zconf)->{'value'});

# links to forms editing text, soa and zone options
if ($access{'file'}) {
	push(@links, "edit_text.cgi?index=$in{'index'}");
	push(@titles, $text{'master_manual'});
	push(@images, "images/text.gif");
	}
if ($access{'params'}) {
	push(@links, "edit_soa.cgi?index=$in{'index'}");
	push(@titles, $text{'master_soa'});
	push(@images, "images/soa.gif");
	}
if ($access{'opts'}) {
	push(@links, "edit_options.cgi?index=$in{'index'}");
	push(@titles, $text{'master_options'});
	push(@images, "images/options.gif");
	}
if ($access{'findfree'}) {
	push(@links, "find_free.cgi?index=$in{'index'}");
	push(@titles, $text{'findfree_desc'});
	push(@images, "images/findfree.gif");
	}

if (@links) {
	print "<hr>\n";
	&icons_table(\@links, \@titles, \@images);
	}

if (!$access{'ro'} && $access{'delete'}) {
	print "<hr>\n";
	print "<form action=delete_zone.cgi>\n";
	print "<input type=hidden name=index value=\"$in{'index'}\">\n";
	print "<table width=100%><tr><td>\n";
	print "<input type=submit value=\"$text{'master_del'}\">\n";
	print "</td> <td>$text{'master_delmsg'}\n";
	if ($dom !~ /in-addr.arpa/i) {
		print "$text{'master_delrev'}\n";
		}
	print "</td> </tr></table>\n";
	}
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub types_table
{
if ($_[0]) {
	local($i);
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'master_type'}</b></td> ",
	      "<td><b>$text{'master_records'}</b></td> </tr>\n";
	for($i=0; $_[$i]; $i++) {
		print "<tr $cb> <td><a href=\"edit_recs.cgi?",
		      "index=$in{'index'}&type=$_[$i]\">",$text{"type_$_[$i]"},
		      "</a></td>\n";
		print "<td>$rnum{$_[$i]}</td> </tr>\n";
		}
	print "</table>\n";
	}
}

