#!/usr/local/bin/perl
# create_slave.cgi
# Create a new slave zone

require './bind8-lib.pl';
&ReadParse();
&error_setup($in{'type'} ? $text{'screate_err1'} : $text{'screate_err2'});
%access = &get_module_acl();
$access{'slave'} || &error($in{'type'} ? $text{'screate_ecannot1'}
				       : $text{'screate_ecannot2'});
$access{'ro'} && &error($text{'master_ero'});

# validate inputs
if ($in{'rev'}) {
        $in{'zone'} =~ /^[0-9\.]+$/ ||
                &error(&text('screate_enet', $in{'zone'}));
        $in{'zone'} = &ip_to_arpa($in{'zone'});
        }
else {
        $in{'zone'} =~ /^[A-z0-9\-\.]+$/ ||
                &error(&text('screate_edom', $in{'zone'}));
        }
$in{'zone'} =~ s/\.$//g;
@masters = split(/\s+/, $in{'masters'});
foreach $m (@masters) {
	&check_ipaddress($m) ||
		&error(&text('screate_emaster', $m));
	}
if (!@masters) {
	&error($text{'screate_enone'});
	}
$base = $config{'slave_dir'} ? $config{'slave_dir'} :
	$access{'dir'} eq '/' ? &base_directory($conf) :
				$access{'dir'};
if ($in{'file_def'} == 0) {
	$in{'file'} =~ /^\S+$/ ||
		&error(&text('screate_efile', $in{'file'}));
	$in{'file'} =~ s/^$config{'chroot'}//;
	if ($in{'file'} !~ /^\//) {
		$file = $base."/".$in{'file'};
		}
	else { $file = $in{'file'}; }
	&allowed_zone_file(\%access, $file) ||
		&error(&text('screate_efile2', $file));
	open(ZONE, "> $config{'chroot'}$file") ||
		&error(&text('screate_efile3', $file, $!));
	close(ZONE);
	}
elsif ($in{'file_def'} == 2) {
	if ($in{'rev'}) {
		$file = $base."/".&arpa_to_ip($in{'zone'}).".rev";
		}
	else {
		$file = $base."/".$in{'zone'}.".hosts";
		}
	}

# Create zone directive
&lock_file($config{'chroot'}.$config{'named_conf'});
open(CONF, ">>$config{'chroot'}$config{'named_conf'}");
print CONF "zone \"$in{'zone'}\" {\n";
print CONF "\ttype ",$in{'type'} ? 'slave' : 'stub',";\n";
if ($file) { print CONF "\tfile \"$file\";\n"; }
print CONF "\tmasters {\n";
foreach $m (@masters) { print CONF "\t\t$m;\n"; }
print CONF "\t\t};\n";
print CONF "\t};\n";
print CONF "\n";
close(CONF);
&unlock_file($config{'chroot'}.$config{'named_conf'});
&webmin_log("create", $in{'type'} ? 'slave' : 'stub', $in{'zone'}, \%in);

# Add the new zone to the access list
if ($access{'zones'} ne '*') {
	$access{'zones'} .= " ".$in{'zone'};
	&save_module_acl(\%access);
	}
&redirect("");

