#!/usr/local/bin/perl
# create_forward.cgi
# Create a new forward zone

require './bind8-lib.pl';
&ReadParse();
&error_setup($text{'fcreate_err'});
%access = &get_module_acl();
$access{'forward'} || &error($text{'fcreate_ecannot'});
$access{'ro'} && &error($text{'master_ero'});

# validate inputs
if ($in{'rev'}) {
        $in{'zone'} =~ /^[0-9\.]+$/ ||
                &error(&text('fcreate_enet', $in{'zone'}));
        $in{'zone'} = &ip_to_arpa($in{'zone'});
        }
else {
        $in{'zone'} =~ /^[A-z0-9\-\.]+$/ ||
                &error(&text('fcreate_edom', $in{'zone'}));
        }
$in{'zone'} =~ s/\.$//g;
@masters = split(/\s+/, $in{'masters'});
foreach $m (@masters) {
	&check_ipaddress($m) ||
		&error(&text('fcreate_emaster', $m));
	}
if (!@masters) {
	&error($text{'fcreate_enone'});
	}

# Create zone directive
&lock_file($config{'chroot'}.$config{'named_conf'});
open(CONF, ">>$config{'chroot'}$config{'named_conf'}");
print CONF "zone \"$in{'zone'}\" {\n";
print CONF "\ttype forward;\n";
print CONF "\tforwarders {\n";
foreach $m (@masters) { print CONF "\t\t$m;\n"; }
print CONF "\t\t};\n";
print CONF "\t};\n";
print CONF "\n";
close(CONF);
&unlock_file($config{'chroot'}.$config{'named_conf'});
&webmin_log("create", "forward", $in{'zone'}, \%in);

# Add the new zone to the access list
if ($access{'zones'} ne '*') {
	$access{'zones'} .= " ".$in{'zone'};
	&save_module_acl(\%access);
	}
&redirect("");

