# mod_cern_meta.pl
# Defines editors CERN metafile directives

sub mod_cern_meta_directives
{
local($rv);
$rv = [ [ 'MetaFiles', 0, 5, 'directory', 1.3 ],
        [ 'MetaDir', 0, 5, 'server', -1.3 ],
        [ 'MetaDir', 0, 5, 'directory', 1.3 ],
        [ 'MetaSuffix', 0, 5, 'server', -1.3 ],
        [ 'MetaSuffix', 0, 5, 'directory', 1.3 ] ];
return &make_directives($rv, $_[0], "mod_cern_meta");
}

sub edit_MetaFiles
{
return (1, "$text{'mod_cern_meta_0'}",
        &choice_input($_[0]->{'value'}, "MetaFiles", "off",
        "$text{'mod_cern_meta_1'},on", "$text{'mod_cern_meta_2'},off"));
}
sub save_MetaFiles
{
return &parse_choice("MetaFiles", "off");
}

sub edit_MetaDir
{
return (1, "$text{'mod_cern_meta_3'}",
        &opt_input($_[0]->{'value'}, "MetaDir", "$text{'mod_cern_meta_4'}", 8));
}
sub save_MetaDir
{
return &parse_opt("MetaDir", '^\S+$', "$text{'mod_cern_meta_5'}");
}

sub edit_MetaSuffix
{
return (1, "$text{'mod_cern_meta_6'}",
        &opt_input($_[0]->{'value'}, "MetaSuffix", "$text{'mod_cern_meta_7'}", 15));
}
sub save_MetaSuffix
{
return &parse_opt("MetaSuffix", '^\S+$', "$text{'mod_cern_meta_8'}");
}

1;

