/*
 * Decompiled with CFR 0.152.
 */
package de.mud.terminal;

import de.mud.terminal.VDU;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;

public abstract class vt320
extends VDU
implements KeyListener {
    public static final String ID = "$Id: vt320.java,v 2.36 2000/07/03 22:26:13 marcus Exp $";
    private static final int debug = 0;
    private boolean localecho = false;
    private int pressedKey = 32;
    private String terminalID = "vt320";
    int R;
    int C;
    int Sc;
    int Sr;
    int Sa;
    int attributes = 0;
    int insertmode = 0;
    int statusmode = 0;
    int vt52mode = 0;
    int normalcursor = 0;
    boolean moveoutsidemargins = true;
    boolean sendcrlf = true;
    boolean capslock = false;
    boolean numlock = false;
    private boolean useibmcharset = false;
    private static int lastwaslf = 0;
    private static int i;
    private static final char ESC = '\u001b';
    private static final char IND = '\u0084';
    private static final char NEL = '\u0085';
    private static final char RI = '\u008d';
    private static final char HTS = '\u0088';
    private static final char DCS = '\u0090';
    private static final char CSI = '\u009b';
    private static final char OSC = '\u009d';
    private static final int TSTATE_DATA = 0;
    private static final int TSTATE_ESC = 1;
    private static final int TSTATE_CSI = 2;
    private static final int TSTATE_DCS = 3;
    private static final int TSTATE_DCEQ = 4;
    private static final int TSTATE_ESCSQUARE = 5;
    private static final int TSTATE_OSC = 6;
    private static final int TSTATE_SETG0 = 7;
    private static final int TSTATE_SETG1 = 8;
    private static final int TSTATE_SETG2 = 9;
    private static final int TSTATE_SETG3 = 10;
    private static final int TSTATE_CSI_DOLLAR = 11;
    private static final int TSTATE_CSI_EX = 12;
    private static char[] gx;
    private static char gr;
    private static char gl;
    private static char[] DECSPECIAL;
    private String[] Numpad;
    private String[] FunctionKey;
    private String[] FunctionKeyShift;
    private String[] FunctionKeyCtrl;
    private String[] FunctionKeyAlt;
    private String[] KeyUp;
    private String[] KeyDown;
    private String[] KeyLeft;
    private String[] KeyRight;
    private String KeyTab;
    private String KeyBacktab;
    private String KPMinus;
    private String KPComma;
    private String KPPeriod;
    private String KPEnter;
    private String PF1;
    private String PF2;
    private String PF3;
    private String PF4;
    private String Help;
    private String Do;
    private String Find;
    private String Select;
    private String[] KeyHome;
    private String[] KeyEnd;
    private String[] Insert;
    private String[] Remove;
    private String[] PrevScn;
    private String[] NextScn;
    private String[] Escape;
    private String[] BackSpace;
    private String osc;
    private String dcs;
    private int term_state = 0;
    private boolean vms = false;
    private byte[] Tabs;
    private int[] DCEvars = new int[10];
    private int DCEvar;
    private static final char[] unimap;

    protected abstract void write(byte[] var1);

    public void putString(String string) {
        int n = string.length();
        if (n > 0) {
            this.markLine(this.R, 1);
            int n2 = 0;
            while (n2 < n) {
                this.putChar(string.charAt(n2), false);
                ++n2;
            }
            this.setCursorPosition(this.C, this.R);
            this.redraw();
        }
    }

    public vt320(int n, int n2, Font font) {
        super(n, n2, font);
        this.setVMS(false);
        this.setIBMCharset(false);
        this.setTerminalID("vt320");
        this.setBufferSize(100);
        this.setBorder(2, false);
        int n3 = this.getColumns();
        if (n3 < 132) {
            n3 = 132;
        }
        this.Tabs = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.Tabs[n4] = 1;
            n4 += 8;
        }
        this.PF1 = "\u001bOP";
        this.PF2 = "\u001bOQ";
        this.PF3 = "\u001bOR";
        this.PF4 = "\u001bOS";
        this.Insert = new String[4];
        this.Remove = new String[4];
        this.KeyHome = new String[4];
        this.KeyEnd = new String[4];
        this.NextScn = new String[4];
        this.PrevScn = new String[4];
        this.Escape = new String[4];
        this.BackSpace = new String[4];
        this.Insert[3] = "\u001b[2~";
        this.Insert[2] = "\u001b[2~";
        this.Insert[1] = "\u001b[2~";
        this.Insert[0] = "\u001b[2~";
        this.Remove[3] = "\u001b[3~";
        this.Remove[2] = "\u001b[3~";
        this.Remove[1] = "\u001b[3~";
        this.Remove[0] = "\u001b[3~";
        this.PrevScn[3] = "\u001b[5~";
        this.PrevScn[2] = "\u001b[5~";
        this.PrevScn[1] = "\u001b[5~";
        this.PrevScn[0] = "\u001b[5~";
        this.NextScn[3] = "\u001b[6~";
        this.NextScn[2] = "\u001b[6~";
        this.NextScn[1] = "\u001b[6~";
        this.NextScn[0] = "\u001b[6~";
        this.KeyHome[3] = "\u001b[H";
        this.KeyHome[2] = "\u001b[H";
        this.KeyHome[1] = "\u001b[H";
        this.KeyHome[0] = "\u001b[H";
        this.KeyEnd[3] = "\u001b[F";
        this.KeyEnd[2] = "\u001b[F";
        this.KeyEnd[1] = "\u001b[F";
        this.KeyEnd[0] = "\u001b[F";
        this.Escape[3] = "\u001b";
        this.Escape[2] = "\u001b";
        this.Escape[1] = "\u001b";
        this.Escape[0] = "\u001b";
        this.BackSpace[3] = "\b";
        this.BackSpace[2] = "\b";
        this.BackSpace[1] = "\b";
        this.BackSpace[0] = "\b";
        this.Find = "\u001b[1~";
        this.Select = "\u001b[4~";
        this.Help = "\u001b[28~";
        this.Do = "\u001b[29~";
        this.FunctionKey = new String[21];
        this.FunctionKey[0] = "";
        this.FunctionKey[1] = this.PF1;
        this.FunctionKey[2] = this.PF2;
        this.FunctionKey[3] = this.PF3;
        this.FunctionKey[4] = this.PF4;
        this.FunctionKey[5] = "\u001b[15~";
        this.FunctionKey[6] = "\u001b[17~";
        this.FunctionKey[7] = "\u001b[18~";
        this.FunctionKey[8] = "\u001b[19~";
        this.FunctionKey[9] = "\u001b[20~";
        this.FunctionKey[10] = "\u001b[21~";
        this.FunctionKey[11] = "\u001b[23~";
        this.FunctionKey[12] = "\u001b[24~";
        this.FunctionKey[13] = "\u001b[25~";
        this.FunctionKey[14] = "\u001b[26~";
        this.FunctionKey[15] = this.Help;
        this.FunctionKey[16] = this.Do;
        this.FunctionKey[17] = "\u001b[31~";
        this.FunctionKey[18] = "\u001b[32~";
        this.FunctionKey[19] = "\u001b[33~";
        this.FunctionKey[20] = "\u001b[34~";
        this.FunctionKeyShift = new String[21];
        this.FunctionKeyAlt = new String[21];
        this.FunctionKeyCtrl = new String[21];
        int n5 = 0;
        while (n5 < 20) {
            this.FunctionKeyShift[n5] = "";
            this.FunctionKeyAlt[n5] = "";
            this.FunctionKeyCtrl[n5] = "";
            ++n5;
        }
        this.FunctionKeyShift[15] = this.Find;
        this.FunctionKeyShift[16] = this.Select;
        this.KeyTab = "\t";
        this.KeyBacktab = "\u001bOP\t";
        this.KeyUp = new String[4];
        this.KeyUp[0] = "\u001b[A";
        this.KeyDown = new String[4];
        this.KeyDown[0] = "\u001b[B";
        this.KeyRight = new String[4];
        this.KeyRight[0] = "\u001b[C";
        this.KeyLeft = new String[4];
        this.KeyLeft[0] = "\u001b[D";
        this.Numpad = new String[10];
        this.Numpad[0] = "\u001bOp";
        this.Numpad[1] = "\u001bOq";
        this.Numpad[2] = "\u001bOr";
        this.Numpad[3] = "\u001bOs";
        this.Numpad[4] = "\u001bOt";
        this.Numpad[5] = "\u001bOu";
        this.Numpad[6] = "\u001bOv";
        this.Numpad[7] = "\u001bOw";
        this.Numpad[8] = "\u001bOx";
        this.Numpad[9] = "\u001bOy";
        this.KPMinus = "\u001bOm";
        this.KPComma = "\u001bOl";
        this.KPPeriod = "\u001bOn";
        this.KPEnter = "\u001bOM";
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                vt320.this.requestFocus();
            }
        });
    }

    public vt320(int n, int n2) {
        this(n, n2, new Font("Monospaced", 0, 10));
    }

    public vt320(Font font) {
        this(80, 24, font);
    }

    public vt320() {
        this(80, 24, new Font("Monospaced", 0, 10));
    }

    public void setLocalEcho(boolean bl) {
        this.localecho = bl;
    }

    public void setVMS(boolean bl) {
        this.vms = bl;
    }

    public void setIBMCharset(boolean bl) {
        this.useibmcharset = bl;
    }

    public void setKeyCodes(Properties properties) {
        String string;
        String[] stringArray = new String[]{"", "S", "C", "A"};
        int n = 0;
        while (n < 10) {
            string = properties.getProperty("NUMPAD" + n);
            if (string != null) {
                this.Numpad[n] = vt320.unEscape(string);
            }
            ++n;
        }
        n = 1;
        while (n < 20) {
            string = properties.getProperty("F" + n);
            if (string != null) {
                this.FunctionKey[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty("SF" + n)) != null) {
                this.FunctionKeyShift[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty("CF" + n)) != null) {
                this.FunctionKeyCtrl[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty("AF" + n)) != null) {
                this.FunctionKeyAlt[n] = vt320.unEscape(string);
            }
            ++n;
        }
        n = 0;
        while (n < 4) {
            string = properties.getProperty(stringArray[n] + "PGUP");
            if (string != null) {
                this.PrevScn[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "PGDOWN")) != null) {
                this.NextScn[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "END")) != null) {
                this.KeyEnd[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "HOME")) != null) {
                this.KeyHome[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "INSERT")) != null) {
                this.Insert[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "REMOVE")) != null) {
                this.Remove[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "UP")) != null) {
                this.KeyUp[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "DOWN")) != null) {
                this.KeyDown[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "LEFT")) != null) {
                this.KeyLeft[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "RIGHT")) != null) {
                this.KeyRight[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "ESCAPE")) != null) {
                this.Escape[n] = vt320.unEscape(string);
            }
            if ((string = properties.getProperty(stringArray[n] + "BACKSPACE")) != null) {
                this.BackSpace[n] = vt320.unEscape(string);
            }
            ++n;
        }
    }

    public void setTerminalID(String string) {
        this.terminalID = string;
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    private boolean write(String string, boolean bl) {
        this.write(string.getBytes());
        if (bl) {
            this.putString(string);
        }
        return true;
    }

    private boolean write(String string) {
        return this.write(string, this.localecho);
    }

    /*
     * Unable to fully structure code
     */
    static String unEscape(String var0) {
        var1_1 = 0;
        var2_2 = 0;
        var3_3 = "";
        if (true) ** GOTO lbl43
        do {
            var3_3 = var3_3 + var0.substring(var2_2, var1_1 - 1);
            if (var1_1 == var0.length()) {
                return var3_3;
            }
            switch (var0.charAt(var1_1)) {
                case 'b': {
                    var3_3 = var3_3 + "\b";
                    break;
                }
                case 'e': {
                    var3_3 = var3_3 + "\u001b";
                    break;
                }
                case 'n': {
                    var3_3 = var3_3 + "\n";
                    break;
                }
                case 'r': {
                    var3_3 = var3_3 + "\r";
                    break;
                }
                case 't': {
                    var3_3 = var3_3 + "\t";
                    break;
                }
                case 'v': {
                    var3_3 = var3_3 + "\u000b";
                    break;
                }
                case 'a': {
                    var3_3 = var3_3 + "\u0012";
                    break;
                }
                default: {
                    if (var0.charAt(var1_1) >= '0' && var0.charAt(var1_1) <= '9') {
                        vt320.i = var1_1;
                        while (vt320.i < var0.length()) {
                            if (var0.charAt(vt320.i) < '0' || var0.charAt(vt320.i) > '9') break;
                            ++vt320.i;
                        }
                        var3_3 = var3_3 + (char)Integer.parseInt(var0.substring(var1_1, vt320.i));
                        var1_1 = vt320.i - 1;
                        break;
                    }
                    var3_3 = var3_3 + var0.substring(var1_1++, var1_1);
                }
            }
            var2_2 = ++var1_1;
lbl43:
            // 2 sources

            var1_1 = var0.indexOf(92, var2_2);
        } while (var1_1 >= 0 && ++var1_1 <= var0.length());
        if (var2_2 <= var0.length()) {
            var3_3 = var3_3 + var0.substring(var2_2);
        }
        return var3_3;
    }

    public void keyTyped(KeyEvent keyEvent) {
        boolean bl = keyEvent.isControlDown();
        boolean bl2 = keyEvent.isShiftDown();
        boolean bl3 = keyEvent.isAltDown();
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (c == '\u001b' || c == '\b') {
            return;
        }
        if (bl2 && c == '\t') {
            this.write(this.KeyBacktab, false);
            return;
        }
        if (bl3) {
            this.write("" + (char)(c | 0x80));
            return;
        }
        if (c != '\r' && c != '\n' || bl) {
            this.write("" + c);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = keyEvent.isControlDown();
        boolean bl2 = keyEvent.isShiftDown();
        boolean bl3 = keyEvent.isAltDown();
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (!(n != 10 && c != '\n' || bl)) {
            this.write("\n", false);
            if (this.localecho) {
                this.putString("\r\n");
            }
        }
        if ((!this.vms && c == '2' || c == ' ') && bl) {
            this.write("\u0000");
        }
        if (this.vms) {
            if (c == '\b') {
                if (bl2 && !bl) {
                    this.write("\n");
                } else if (bl && !bl2) {
                    this.write("\u0018");
                } else {
                    this.write("\u007f");
                }
            } else if (c == '\u007f' && !bl) {
                if (bl2) {
                    this.write(this.Insert[0]);
                } else {
                    this.write(this.Remove[0]);
                }
            } else if (bl) {
                switch (c) {
                    case '0': {
                        this.write(this.Numpad[0]);
                        return;
                    }
                    case '1': {
                        this.write(this.Numpad[1]);
                        return;
                    }
                    case '2': {
                        this.write(this.Numpad[2]);
                        return;
                    }
                    case '3': {
                        this.write(this.Numpad[3]);
                        return;
                    }
                    case '4': {
                        this.write(this.Numpad[4]);
                        return;
                    }
                    case '5': {
                        this.write(this.Numpad[5]);
                        return;
                    }
                    case '6': {
                        this.write(this.Numpad[6]);
                        return;
                    }
                    case '7': {
                        this.write(this.Numpad[7]);
                        return;
                    }
                    case '8': {
                        this.write(this.Numpad[8]);
                        return;
                    }
                    case '9': {
                        this.write(this.Numpad[9]);
                        return;
                    }
                    case '.': {
                        this.write(this.KPPeriod);
                        return;
                    }
                    case '\u001f': 
                    case '-': {
                        this.write(this.KPMinus);
                        return;
                    }
                    case '+': {
                        this.write(this.KPComma);
                        return;
                    }
                    case '\n': {
                        this.write(this.KPEnter);
                        return;
                    }
                    case '/': {
                        this.write(this.PF2);
                        return;
                    }
                    case '*': {
                        this.write(this.PF3);
                        return;
                    }
                }
            }
            if (bl2 && c < ' ') {
                this.write(this.PF1 + (char)(c + 64));
            }
            return;
        }
        int n2 = 0;
        String[] stringArray = this.FunctionKey;
        if (bl2) {
            stringArray = this.FunctionKeyShift;
            n2 = 1;
        }
        if (bl) {
            stringArray = this.FunctionKeyCtrl;
            n2 = 2;
        }
        if (bl3) {
            stringArray = this.FunctionKeyAlt;
            n2 = 3;
        }
        if (keyEvent.isActionKey()) {
            switch (n) {
                case 96: {
                    this.write(this.Numpad[0], false);
                    break;
                }
                case 97: {
                    this.write(this.Numpad[1], false);
                    break;
                }
                case 98: {
                    this.write(this.Numpad[2], false);
                    break;
                }
                case 99: {
                    this.write(this.Numpad[3], false);
                    break;
                }
                case 100: {
                    this.write(this.Numpad[4], false);
                    break;
                }
                case 101: {
                    this.write(this.Numpad[5], false);
                    break;
                }
                case 102: {
                    this.write(this.Numpad[6], false);
                    break;
                }
                case 103: {
                    this.write(this.Numpad[7], false);
                    break;
                }
                case 104: {
                    this.write(this.Numpad[8], false);
                    break;
                }
                case 105: {
                    this.write(this.Numpad[9], false);
                }
            }
        }
        switch (n) {
            case 112: {
                this.write(stringArray[1], false);
                break;
            }
            case 113: {
                this.write(stringArray[2], false);
                break;
            }
            case 114: {
                this.write(stringArray[3], false);
                break;
            }
            case 115: {
                this.write(stringArray[4], false);
                break;
            }
            case 116: {
                this.write(stringArray[5], false);
                break;
            }
            case 117: {
                this.write(stringArray[6], false);
                break;
            }
            case 118: {
                this.write(stringArray[7], false);
                break;
            }
            case 119: {
                this.write(stringArray[8], false);
                break;
            }
            case 120: {
                this.write(stringArray[9], false);
                break;
            }
            case 121: {
                this.write(stringArray[10], false);
                break;
            }
            case 122: {
                this.write(stringArray[11], false);
                break;
            }
            case 123: {
                this.write(stringArray[12], false);
                break;
            }
            case 38: {
                this.write(this.KeyUp[n2], false);
                break;
            }
            case 40: {
                this.write(this.KeyDown[n2], false);
                break;
            }
            case 37: {
                this.write(this.KeyLeft[n2], false);
                break;
            }
            case 39: {
                this.write(this.KeyRight[n2], false);
                break;
            }
            case 34: {
                this.write(this.NextScn[n2], false);
                break;
            }
            case 33: {
                this.write(this.PrevScn[n2], false);
                break;
            }
            case 155: {
                this.write(this.Insert[n2], false);
                break;
            }
            case 127: {
                this.write(this.Remove[n2], false);
                break;
            }
            case 27: {
                this.write(this.Escape[n2], false);
                break;
            }
            case 8: {
                this.write(this.BackSpace[n2]);
                break;
            }
            case 36: {
                if (this.vms) {
                    this.write("\b", false);
                    break;
                }
                this.write(this.KeyHome[n2], false);
                break;
            }
            case 35: {
                if (this.vms) {
                    this.write("\u0005", false);
                    break;
                }
                this.write(this.KeyEnd[n2], false);
                break;
            }
            case 144: {
                if (this.vms && bl) {
                    if (this.pressedKey != n) {
                        this.pressedKey = n;
                        this.write(this.PF1, false);
                    } else {
                        this.pressedKey = 32;
                    }
                }
                if (bl) break;
                this.numlock = !this.numlock;
                break;
            }
            case 20: {
                this.capslock = !this.capslock;
                break;
            }
        }
    }

    private void handle_dcs(String string) {
        System.out.println("DCS: " + string);
    }

    private void handle_osc(String string) {
        System.out.println("OSC: " + string);
    }

    public char map_cp850_unicode(char c) {
        if (c >= '\u0100') {
            return c;
        }
        return unimap[c];
    }

    private void _SetCursor(int n, int n2) {
        int n3 = this.getRows();
        int n4 = this.getTopMargin();
        this.R = n < 0 ? 0 : n;
        int n5 = this.C = n2 < 0 ? 0 : n2;
        if (!this.moveoutsidemargins) {
            this.R += this.getTopMargin();
            n3 = this.getBottomMargin();
        }
        if (this.R > n3) {
            this.R = n3;
        }
    }

    private void putChar(char c, boolean bl) {
        int n = this.getRows();
        int n2 = this.getColumns();
        int n3 = this.getTopMargin();
        int n4 = this.getBottomMargin();
        this.markLine(this.R, 1);
        if (c > '\u00ff') {
            return;
        }
        block0 : switch (this.term_state) {
            case 0: {
                if (!this.useibmcharset) {
                    boolean bl2 = true;
                    switch (c) {
                        case '\u009d': {
                            this.osc = "";
                            this.term_state = 6;
                            break;
                        }
                        case '\u008d': {
                            if (this.R > n3) {
                                --this.R;
                                break;
                            }
                            this.insertLine(this.R, 1, true);
                            break;
                        }
                        case '\u0084': {
                            if (this.R == n3 - 1 || this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                                break;
                            }
                            ++this.R;
                            break;
                        }
                        case '\u0085': {
                            if (this.R == n3 - 1 || this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                            } else {
                                ++this.R;
                            }
                            this.C = 0;
                            break;
                        }
                        case '\u0088': {
                            this.Tabs[this.C] = 1;
                            break;
                        }
                        case '\u0090': {
                            this.dcs = "";
                            this.term_state = 3;
                            break;
                        }
                        default: {
                            bl2 = false;
                        }
                    }
                    if (bl2) break;
                }
                switch (c) {
                    case '\u009b': {
                        this.term_state = 4;
                        break;
                    }
                    case '\u001b': {
                        this.term_state = 1;
                        lastwaslf = 0;
                        break;
                    }
                    case '\b': {
                        --this.C;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        lastwaslf = 0;
                        break;
                    }
                    case '\t': {
                        if (this.insertmode == 1) {
                            int n5 = this.C;
                            do {
                                this.insertChar(this.C, this.R, ' ', this.attributes);
                            } while (++n5 < n2 && this.Tabs[n5] == 0);
                        } else {
                            do {
                                this.putChar(this.C++, this.R, ' ', this.attributes);
                            } while (this.C < n2 && this.Tabs[this.C] == 0);
                        }
                        lastwaslf = 0;
                        break;
                    }
                    case '\r': {
                        this.C = 0;
                        break;
                    }
                    case '\n': {
                        if (!this.vms) {
                            if (lastwaslf != 0 && lastwaslf != c) break block0;
                            lastwaslf = c;
                        }
                        if (this.R == n4 || this.R >= n - 1) {
                            this.insertLine(this.R, 1);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case '\u000e': {
                        gl = '\u0001';
                        break;
                    }
                    case '\u000f': {
                        gl = '\u0000';
                        break;
                    }
                    default: {
                        lastwaslf = 0;
                        if (c < ' ') {
                            if (c == '\u0000') break block0;
                            break;
                        }
                        if (this.C >= n2) {
                            if (this.R < n - 1) {
                                ++this.R;
                            } else {
                                this.insertLine(this.R, false);
                            }
                            this.C = 0;
                        }
                        if (gx[gl] == '0' && c >= '_' && c <= '~') {
                            c = DECSPECIAL[(short)c - 95];
                        }
                        if (this.useibmcharset) {
                            c = this.map_cp850_unicode(c);
                        }
                        if (this.insertmode == 1) {
                            this.insertChar(this.C, this.R, c, this.attributes);
                        } else {
                            this.putChar(this.C, this.R, c, this.attributes);
                        }
                        ++this.C;
                        break;
                    }
                }
                break;
            }
            case 6: {
                if (c < ' ' && c != '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                if (c == '\\' && this.osc.charAt(this.osc.length() - 1) == '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                this.osc = this.osc + c;
                break;
            }
            case 1: {
                this.term_state = 0;
                switch (c) {
                    case '#': {
                        this.term_state = 5;
                        break;
                    }
                    case 'c': {
                        vt320.gx[0] = 66;
                        vt320.gx[1] = 48;
                        vt320.gx[2] = 65;
                        vt320.gx[3] = 60;
                        gl = '\u0000';
                        gr = '\u0001';
                        int n6 = this.getColumns();
                        if (n6 < 132) {
                            n6 = 132;
                        }
                        this.Tabs = new byte[n6];
                        int n7 = 0;
                        while (n7 < n6) {
                            this.Tabs[n7] = 1;
                            n7 += 8;
                        }
                        break block0;
                    }
                    case '[': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case ']': {
                        this.osc = "";
                        this.term_state = 6;
                        break;
                    }
                    case 'P': {
                        this.dcs = "";
                        this.term_state = 3;
                        break;
                    }
                    case 'E': {
                        if (this.R == n3 - 1 || this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                        } else {
                            ++this.R;
                        }
                        this.C = 0;
                        break;
                    }
                    case 'D': {
                        if (this.R == n3 - 1 || this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case 'M': {
                        if (this.R < n3 || this.R > n4) break block0;
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'H': {
                        if (this.C >= n2) {
                            this.C = n2 - 1;
                        }
                        this.Tabs[this.C] = 1;
                        break;
                    }
                    case '=': {
                        break;
                    }
                    case '>': {
                        break;
                    }
                    case '7': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sa = this.attributes;
                        break;
                    }
                    case '8': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.attributes = this.Sa;
                        break;
                    }
                    case '(': {
                        this.term_state = 7;
                        break;
                    }
                    case ')': {
                        this.term_state = 8;
                        break;
                    }
                    case '*': {
                        this.term_state = 9;
                        break;
                    }
                    case '+': {
                        this.term_state = 10;
                        break;
                    }
                    case '~': {
                        gr = '\u0001';
                        break;
                    }
                    case 'n': {
                        gl = (char)2;
                        break;
                    }
                    case '}': {
                        gr = (char)2;
                        break;
                    }
                    case 'o': {
                        gl = (char)3;
                        break;
                    }
                    case '|': {
                        gr = (char)3;
                        break;
                    }
                    default: {
                        System.out.println("ESC unknown letter: (" + c + ")");
                        break;
                    }
                }
                break;
            }
            case 7: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC ( " + c + ": G0 char set?  (" + c + ")");
                } else {
                    vt320.gx[0] = c;
                }
                this.term_state = 0;
                break;
            }
            case 8: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC ) " + c + " (" + c + ") :G1 char set?");
                } else {
                    vt320.gx[1] = c;
                }
                this.term_state = 0;
                break;
            }
            case 9: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC*:G2 char set?  (" + c + ")");
                } else {
                    vt320.gx[2] = c;
                }
                this.term_state = 0;
                break;
            }
            case 10: {
                if (c != '0' && c != 'A' && c != 'B') {
                    System.out.println("ESC+:G3 char set?  (" + c + ")");
                } else {
                    vt320.gx[3] = c;
                }
                this.term_state = 0;
                break;
            }
            case 5: {
                switch (c) {
                    case '8': {
                        int n8 = 0;
                        while (n8 < n2) {
                            int n9 = 0;
                            while (n9 < n) {
                                this.putChar(n8, n9, 'E', 0);
                                ++n9;
                            }
                            ++n8;
                        }
                        break;
                    }
                    default: {
                        System.out.println("ESC # " + c + " not supported.");
                    }
                }
                this.term_state = 0;
                break;
            }
            case 3: {
                if (c == '\\' && this.dcs.charAt(this.dcs.length() - 1) == '\u001b') {
                    this.handle_dcs(this.dcs);
                    this.term_state = 0;
                    break;
                }
                this.dcs = this.dcs + c;
                break;
            }
            case 4: {
                this.term_state = 0;
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 4;
                        break block0;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 4;
                        break block0;
                    }
                    case 'r': {
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " r");
                        switch (this.DCEvars[0]) {
                            case 3: {
                                Dimension dimension = this.getSize();
                                this.setScreenSize(80, n);
                                break block0;
                            }
                            case 4: {
                                break block0;
                            }
                            case 5: {
                                break block0;
                            }
                            case 6: {
                                this.moveoutsidemargins = true;
                                break block0;
                            }
                            case 12: {
                                break block0;
                            }
                        }
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " r, unimplemented!");
                        break block0;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                this.KeyUp[0] = "\u001bOA";
                                this.KeyDown[0] = "\u001bOB";
                                this.KeyRight[0] = "\u001bOC";
                                this.KeyLeft[0] = "\u001bOD";
                                break block0;
                            }
                            case 3: {
                                Dimension dimension = this.getSize();
                                this.setScreenSize(132, n);
                                break block0;
                            }
                            case 6: {
                                this.moveoutsidemargins = false;
                                break block0;
                            }
                            case 25: {
                                this.showCursor(true);
                                this.redraw();
                                break block0;
                            }
                        }
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " h, unsupported.");
                        break block0;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                break block0;
                            }
                            case 4: {
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                this.KeyUp[0] = "\u001b[A";
                                this.KeyDown[0] = "\u001b[B";
                                this.KeyRight[0] = "\u001b[C";
                                this.KeyLeft[0] = "\u001b[D";
                                break block0;
                            }
                            case 3: {
                                Dimension dimension = this.getSize();
                                this.setScreenSize(80, n);
                                break block0;
                            }
                            case 6: {
                                this.moveoutsidemargins = true;
                                break block0;
                            }
                            case 25: {
                                this.showCursor(false);
                                this.redraw();
                                break block0;
                            }
                        }
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " l, unsupported.");
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 15: {
                                this.write("\u001b[?13n", false);
                                System.out.println("ESC[5n");
                                break block0;
                            }
                        }
                        System.out.println("ESC [ ? " + this.DCEvars[0] + " n, unsupported.");
                        break block0;
                    }
                }
                System.out.println("ESC [ ? " + this.DCEvars[0] + " " + c + ", unsupported.");
                break;
            }
            case 12: {
                this.term_state = 0;
                switch (c) {
                    case '\u001b': {
                        this.term_state = 1;
                        break block0;
                    }
                }
                System.out.println("Unknown character ESC[! character is " + c);
                break;
            }
            case 11: {
                this.term_state = 0;
                switch (c) {
                    case '}': {
                        System.out.println("Active Status Display now " + this.DCEvars[0]);
                        this.statusmode = this.DCEvars[0];
                        break block0;
                    }
                    case '~': {
                        System.out.println("Status Line mode now " + this.DCEvars[0]);
                        break block0;
                    }
                }
                System.out.println("UNKNOWN Status Display code " + c + ", with Pn=" + this.DCEvars[0]);
                break;
            }
            case 2: {
                this.term_state = 0;
                block102 : switch (c) {
                    case '$': {
                        this.term_state = 11;
                        break;
                    }
                    case '!': {
                        this.term_state = 12;
                        break;
                    }
                    case '?': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 2;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case 'c': {
                        this.write("\u001b[?1;2c", false);
                        break;
                    }
                    case 'q': {
                        break;
                    }
                    case 'g': {
                        switch (this.DCEvars[0]) {
                            case 3: {
                                int n10 = this.getColumns();
                                this.Tabs = new byte[n10];
                                break block102;
                            }
                            case 0: {
                                this.Tabs[this.C] = 0;
                            }
                        }
                        break;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 1;
                                break block102;
                            }
                            case 20: {
                                System.out.println("Setting CRLF to TRUE");
                                this.sendcrlf = true;
                                break block102;
                            }
                        }
                        System.out.println("unsupported: ESC [ " + this.DCEvars[0] + " h");
                        break;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                break block102;
                            }
                            case 4: {
                                break block102;
                            }
                            case 5: {
                                break block102;
                            }
                        }
                        System.out.println("ESC [ " + this.DCEvars[0] + " i, unimplemented!");
                        break;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 0;
                                break block102;
                            }
                            case 20: {
                                System.out.println("Setting CRLF to FALSE");
                                this.sendcrlf = false;
                                break block102;
                            }
                        }
                        System.out.println("ESC [ " + this.DCEvars[0] + " l, unimplemented!");
                        break;
                    }
                    case 'A': {
                        int n11 = this.R > n4 ? n4 + 1 : (this.R >= n3 ? n3 : 0);
                        this.R = this.DCEvars[0] == 0 ? --this.R : (this.R -= this.DCEvars[0]);
                        if (this.R >= n11) break block0;
                        this.R = n11;
                        break;
                    }
                    case 'B': {
                        int n12 = this.R < n3 ? n3 - 1 : (this.R <= n4 ? n4 : n - 1);
                        this.R = this.DCEvars[0] == 0 ? ++this.R : (this.R += this.DCEvars[0]);
                        if (this.R <= n12) break block0;
                        this.R = n12;
                        break;
                    }
                    case 'C': {
                        this.C = this.DCEvars[0] == 0 ? ++this.C : (this.C += this.DCEvars[0]);
                        if (this.C <= n2 - 1) break block0;
                        this.C = n2 - 1;
                        break;
                    }
                    case 'd': {
                        this.R = this.DCEvars[0];
                        System.out.println("ESC [ " + this.DCEvars[0] + " d");
                        break;
                    }
                    case 'D': {
                        this.C = this.DCEvars[0] == 0 ? --this.C : (this.C -= this.DCEvars[0]);
                        if (this.C >= 0) break block0;
                        this.C = 0;
                        break;
                    }
                    case 'r': {
                        if (this.DCEvar > 0) {
                            this.R = this.DCEvars[1] - 1;
                            if (this.R < 0) {
                                this.R = n - 1;
                            } else if (this.R >= n) {
                                this.R = n - 1;
                            }
                        } else {
                            this.R = n - 1;
                        }
                        this.setBottomMargin(this.DCEvars[1] - 1);
                        if (this.R >= this.DCEvars[0]) {
                            this.R = this.DCEvars[0] - 1;
                            if (this.R < 0) {
                                this.R = 0;
                            }
                        }
                        this.setTopMargin(this.DCEvars[0] - 1);
                        this._SetCursor(0, 0);
                        break;
                    }
                    case 'G': {
                        this.C = this.DCEvars[0];
                        break;
                    }
                    case 'H': {
                        this._SetCursor(this.DCEvars[0] - 1, this.DCEvars[1] - 1);
                        break;
                    }
                    case 'f': {
                        this.R = this.DCEvars[0] - 1;
                        this.C = this.DCEvars[1] - 1;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        if (this.R >= 0) break block0;
                        this.R = 0;
                        break;
                    }
                    case 'L': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(this.R, true);
                            break;
                        }
                        this.insertLine(this.R, this.DCEvars[0], true);
                        break;
                    }
                    case 'M': {
                        if (this.DCEvars[0] == 0) {
                            this.deleteLine(this.R);
                            break;
                        }
                        int n13 = 0;
                        while (n13 < this.DCEvars[0]) {
                            this.deleteLine(this.R);
                            ++n13;
                        }
                        break block0;
                    }
                    case 'K': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1);
                                break block102;
                            }
                            case 1: {
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C, 1);
                                break block102;
                            }
                            case 2: {
                                this.deleteArea(0, this.R, n2, 1);
                            }
                        }
                        break;
                    }
                    case 'J': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.R < n - 1) {
                                    this.deleteArea(0, this.R + 1, n2, n - this.R - 1);
                                }
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1);
                                break block102;
                            }
                            case 1: {
                                if (this.R > 0) {
                                    this.deleteArea(0, 0, n2, this.R - 1);
                                }
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C, 1);
                                break block102;
                            }
                            case 2: {
                                this.deleteArea(0, 0, n2, n);
                            }
                        }
                        break;
                    }
                    case '@': {
                        int n14 = 0;
                        while (n14 < this.DCEvars[0]) {
                            this.insertChar(this.C, this.R, ' ', this.attributes);
                            ++n14;
                        }
                        break block0;
                    }
                    case 'P': {
                        if (this.DCEvars[0] == 0) {
                            this.DCEvars[0] = 1;
                        }
                        int n15 = 0;
                        while (n15 < this.DCEvars[0]) {
                            this.deleteChar(this.C, this.R);
                            ++n15;
                        }
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 5: {
                                this.write("\u001b[0n", false);
                                break block102;
                            }
                            case 6: {
                                this.write("\u001b[" + this.R + ";" + this.C + "R", false);
                                break block102;
                            }
                        }
                        break;
                    }
                    case 's': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sa = this.attributes;
                        break;
                    }
                    case 'u': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.attributes = this.Sa;
                        break;
                    }
                    case 'm': {
                        if (this.DCEvar == 0 && this.DCEvars[0] == 0) {
                            this.attributes = 0;
                        }
                        i = 0;
                        while (i <= this.DCEvar) {
                            switch (this.DCEvars[i]) {
                                case 0: {
                                    if (this.DCEvar <= 0) break;
                                    this.attributes = 0;
                                    break;
                                }
                                case 4: {
                                    this.attributes |= 2;
                                    break;
                                }
                                case 1: {
                                    this.attributes |= 1;
                                    break;
                                }
                                case 7: {
                                    this.attributes |= 4;
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                                case 25: {
                                    break;
                                }
                                case 27: {
                                    this.attributes &= 0xFFFFFFFB;
                                    break;
                                }
                                case 24: {
                                    this.attributes &= 0xFFFFFFFD;
                                    break;
                                }
                                case 22: {
                                    this.attributes &= 0xFFFFFFFE;
                                    break;
                                }
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: {
                                    this.attributes &= 0xFFFFFF87;
                                    this.attributes |= this.DCEvars[i] - 30 + 1 << 3;
                                    break;
                                }
                                case 39: {
                                    this.attributes &= 0xFFFFFF87;
                                    break;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    this.attributes &= 0xFFFFF87F;
                                    this.attributes |= this.DCEvars[i] - 40 + 1 << 7;
                                    break;
                                }
                                case 49: {
                                    this.attributes &= 0xFFFFF87F;
                                    break;
                                }
                                default: {
                                    System.out.println("ESC [ " + this.DCEvars[i] + " m unknown...");
                                }
                            }
                            ++i;
                        }
                        break block0;
                    }
                    default: {
                        System.out.println("ESC [ unknown letter:" + c + " (" + c + ")");
                        break;
                    }
                }
                break;
            }
            default: {
                this.term_state = 0;
            }
        }
        if (this.C > n2) {
            this.C = n2;
        }
        if (this.R > n) {
            this.R = n;
        }
        if (this.C < 0) {
            this.C = 0;
        }
        if (this.R < 0) {
            this.R = 0;
        }
        if (bl) {
            this.setCursorPosition(this.C, this.R);
        }
        this.markLine(this.R, 1);
    }

    public void reset() {
        vt320.gx[0] = 66;
        vt320.gx[1] = 48;
        vt320.gx[2] = 65;
        vt320.gx[3] = 60;
        gl = '\u0000';
        gr = '\u0001';
        int n = this.getColumns();
        if (n < 132) {
            n = 132;
        }
        this.Tabs = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            this.Tabs[n2] = 1;
            n2 += 8;
        }
        this.term_state = 0;
    }

    static {
        gx = new char[]{'B', '0', 'A', '<'};
        gr = '\u0001';
        gl = '\u0000';
        DECSPECIAL = new char[]{'@', '\u2666', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00ba', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u2594', '\u2580', '\u2500', '\u25ac', '_', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u00b6', '\u2260', '\u00a3', '\u00b7'};
        unimap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00a2', '\u00a3', '\u00a5', '\u20a7', '\u0192', '\u00e1', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00d1', '\u00aa', '\u00ba', '\u00bf', '\u2310', '\u00ac', '\u00bd', '\u00bc', '\u00a1', '\u00ab', '\u00bb', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561', '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255d', '\u255c', '\u255b', '\u2510', '\u2514', '\u2534', '\u252c', '\u251c', '\u2500', '\u253c', '\u255e', '\u255f', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553', '\u256b', '\u256a', '\u2518', '\u250c', '\u2588', '\u2584', '\u258c', '\u2590', '\u2580', '\u03b1', '\u00df', '\u0393', '\u03c0', '\u03a3', '\u03c3', '\u00b5', '\u03c4', '\u03a6', '\u0398', '\u03a9', '\u03b4', '\u221e', '\u03c6', '\u03b5', '\u2229', '\u2261', '\u00b1', '\u2265', '\u2264', '\u2320', '\u2321', '\u00f7', '\u2248', '\u00b0', '\u2219', '\u00b7', '\u221a', '\u207f', '\u00b2', '\u25a0', '\u00a0'};
    }
}

