/*
 * Decompiled with CFR 0.152.
 */
package de.mud.terminal;

import de.mud.terminal.SoftFont;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class VDU
extends Component
implements MouseListener,
MouseMotionListener {
    public static final String ID = "$Id: VDU.java,v 2.27 2000/07/07 12:53:25 leo Exp $";
    public static final int debug = 0;
    private static final long VDU_EVENTS = 188L;
    private Dimension size;
    private Insets insets;
    private boolean raised;
    private char[][] charArray;
    private int[][] charAttributes;
    private int bufSize;
    private int maxBufSize;
    private int windowBase;
    private int screenBase;
    private int topMargin;
    private int bottomMargin;
    private Font normalFont;
    private FontMetrics fm;
    private int charWidth;
    private int charHeight;
    private int charDescent;
    private int resizeStrategy;
    private int cursorX;
    private int cursorY;
    private boolean showcursor = true;
    private Point selectBegin;
    private Point selectEnd;
    private String selection;
    private Scrollbar scrollBar;
    private SoftFont sf = new SoftFont();
    private boolean[] update;
    private boolean colorPrinting = false;
    private Image backingStore = null;
    private Color[] color = new Color[]{this.brighten(Color.black), this.brighten(Color.red), this.brighten(Color.green), this.brighten(Color.yellow), this.brighten(Color.blue), this.brighten(Color.magenta), this.brighten(Color.cyan), this.brighten(Color.white)};
    public static final int COLOR_0 = 0;
    public static final int COLOR_1 = 1;
    public static final int COLOR_2 = 2;
    public static final int COLOR_3 = 3;
    public static final int COLOR_4 = 4;
    public static final int COLOR_5 = 5;
    public static final int COLOR_6 = 6;
    public static final int COLOR_7 = 7;
    private static int COLOR_FG_STD = 7;
    private static int COLOR_FG_BOLD = 3;
    private static int COLOR_BG_STD = 0;
    private static final int COLOR = 2040;
    private static final int COLOR_FG = 120;
    private static final int COLOR_BG = 1920;
    public static final boolean SCROLL_UP = false;
    public static final boolean SCROLL_DOWN = true;
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_SCREEN = 1;
    public static final int RESIZE_FONT = 2;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int UNDERLINE = 2;
    public static final int INVERT = 4;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private KeyListener keyListener;
    FocusListener focusListener;

    private Color brighten(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.85), 0), Math.max((int)((double)color.getGreen() * 0.85), 0), Math.max((int)((double)color.getBlue() * 0.85), 0));
    }

    public VDU(int n, int n2, Font font) {
        this.enableEvents(188L);
        this.setFont(font);
        this.setResizeStrategy(2);
        this.setScreenSize(n, n2);
        this.setForeground(Color.white);
        this.setBackground(Color.black);
        this.clearSelection();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.selection = null;
    }

    public VDU(int n, int n2) {
        this(n, n2, new Font("Monospaced", 0, 11));
    }

    public VDU(Font font) {
        this(80, 24, font);
    }

    public VDU() {
        this(80, 24, new Font("Monospaced", 0, 11));
    }

    public void setColorSet(Color[] colorArray) {
        System.arraycopy(colorArray, 0, this.color, 0, 8);
        this.update[0] = true;
        this.redraw();
    }

    public Color[] getColorSet() {
        return this.color;
    }

    public void putChar(int n, int n2, char c) {
        this.putChar(n, n2, c, 0);
    }

    public void putChar(int n, int n2, char c, int n3) {
        n = this.checkBounds(n, 0, this.size.width - 1);
        n2 = this.checkBounds(n2, 0, this.size.height - 1);
        this.charArray[this.screenBase + n2][n] = c;
        this.charAttributes[this.screenBase + n2][n] = n3;
        this.markLine(n2, 1);
    }

    public char getChar(int n, int n2) {
        n = this.checkBounds(n, 0, this.size.width - 1);
        n2 = this.checkBounds(n2, 0, this.size.height - 1);
        return this.charArray[this.screenBase + n2][n];
    }

    public int getAttributes(int n, int n2) {
        n = this.checkBounds(n, 0, this.size.width - 1);
        n2 = this.checkBounds(n2, 0, this.size.height - 1);
        return this.charAttributes[this.screenBase + n2][n];
    }

    public void insertChar(int n, int n2, char c, int n3) {
        n = this.checkBounds(n, 0, this.size.width - 1);
        n2 = this.checkBounds(n2, 0, this.size.height - 1);
        System.arraycopy(this.charArray[this.screenBase + n2], n, this.charArray[this.screenBase + n2], n + 1, this.size.width - n - 1);
        System.arraycopy(this.charAttributes[this.screenBase + n2], n, this.charAttributes[this.screenBase + n2], n + 1, this.size.width - n - 1);
        this.putChar(n, n2, c, n3);
    }

    public void deleteChar(int n, int n2) {
        n = this.checkBounds(n, 0, this.size.width - 1);
        n2 = this.checkBounds(n2, 0, this.size.height - 1);
        if (n < this.size.width - 1) {
            System.arraycopy(this.charArray[this.screenBase + n2], n + 1, this.charArray[this.screenBase + n2], n, this.size.width - n - 1);
            System.arraycopy(this.charAttributes[this.screenBase + n2], n + 1, this.charAttributes[this.screenBase + n2], n, this.size.width - n - 1);
        }
        this.putChar(this.size.width - 1, n2, '\u0000');
    }

    public void putString(int n, int n2, String string) {
        this.putString(n, n2, string, 0);
    }

    public void putString(int n, int n2, String string, int n3) {
        int n4 = 0;
        while (n4 < string.length() && n + n4 < this.size.width) {
            this.putChar(n + n4, n2, string.charAt(n4), n3);
            ++n4;
        }
    }

    public void insertLine(int n) {
        this.insertLine(n, 1, false);
    }

    public void insertLine(int n, int n2) {
        this.insertLine(n, n2, false);
    }

    public void insertLine(int n, boolean bl) {
        this.insertLine(n, 1, bl);
    }

    public synchronized void insertLine(int n, int n2, boolean bl) {
        int n3;
        int n4;
        n = this.checkBounds(n, 0, this.size.height - 1);
        char[][] cArray = null;
        int[][] nArray = null;
        int n5 = 0;
        int n6 = this.screenBase;
        int n7 = n < this.topMargin ? 0 : (n > this.bottomMargin ? (this.bottomMargin + 1 < this.size.height ? this.bottomMargin + 1 : this.size.height - 1) : (n4 = this.topMargin));
        int n8 = n > this.bottomMargin ? this.size.height - 1 : (n < this.topMargin ? (this.topMargin > 0 ? this.topMargin - 1 : 0) : (n3 = this.bottomMargin));
        if (bl) {
            if (n2 > n3 - n4) {
                n2 = n3 - n4;
            }
            cArray = new char[n3 - n - (n2 - 1)][this.size.width];
            nArray = new int[n3 - n - (n2 - 1)][this.size.width];
            System.arraycopy(this.charArray, n6 + n, cArray, 0, n3 - n - (n2 - 1));
            System.arraycopy(this.charAttributes, n6 + n, nArray, 0, n3 - n - (n2 - 1));
            System.arraycopy(cArray, 0, this.charArray, n6 + n + n2, n3 - n - (n2 - 1));
            System.arraycopy(nArray, 0, this.charAttributes, n6 + n + n2, n3 - n - (n2 - 1));
            cArray = this.charArray;
            nArray = this.charAttributes;
        } else {
            try {
                if (n2 > n3 - n4 + 1) {
                    n2 = n3 - n4 + 1;
                }
                if (this.bufSize < this.maxBufSize) {
                    if (this.bufSize + n2 > this.maxBufSize) {
                        n5 = n2 - (this.maxBufSize - this.bufSize);
                        this.bufSize = this.maxBufSize;
                        this.windowBase = this.screenBase = this.maxBufSize - this.size.height - 1;
                    } else {
                        this.screenBase += n2;
                        this.windowBase += n2;
                        this.bufSize += n2;
                    }
                    cArray = new char[this.bufSize][this.size.width];
                    nArray = new int[this.bufSize][this.size.width];
                } else {
                    n5 = n2;
                    cArray = this.charArray;
                    nArray = this.charAttributes;
                }
                if (n6 > 0) {
                    System.arraycopy(this.charArray, n5, cArray, 0, n6 - n5);
                    System.arraycopy(this.charAttributes, n5, nArray, 0, n6 - n5);
                }
                if (n4 > 0) {
                    System.arraycopy(this.charArray, n6, cArray, this.screenBase, n4);
                    System.arraycopy(this.charAttributes, n6, nArray, this.screenBase, n4);
                }
                if (n6 > 0) {
                    System.arraycopy(this.charArray, n6 + n4, cArray, n6 - n5, n2);
                    System.arraycopy(this.charAttributes, n6 + n4, nArray, n6 - n5, n2);
                }
                System.arraycopy(this.charArray, n6 + n4 + n2, cArray, this.screenBase + n4, n - n4 - (n2 - 1));
                System.arraycopy(this.charAttributes, n6 + n4 + n2, nArray, this.screenBase + n4, n - n4 - (n2 - 1));
                if (n < this.size.height - 1) {
                    System.arraycopy(this.charArray, n6 + n + 1, cArray, this.screenBase + n + 1, this.size.height - 1 - n);
                    System.arraycopy(this.charAttributes, n6 + n + 1, nArray, this.screenBase + n + 1, this.size.height - 1 - n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("*** Error while scrolling up:");
                System.err.println("--- BEGIN STACK TRACE ---");
                arrayIndexOutOfBoundsException.printStackTrace();
                System.err.println("--- END STACK TRACE ---");
                System.err.println("bufSize=" + this.bufSize + ", maxBufSize=" + this.maxBufSize);
                System.err.println("top=" + n4 + ", bottom=" + n3);
                System.err.println("n=" + n2 + ", l=" + n);
                System.err.println("screenBase=" + this.screenBase + ", windowBase=" + this.windowBase);
                System.err.println("oldBase=" + n6);
                System.err.println("size.width=" + this.size.width + ", size.height=" + this.size.height);
                System.err.println("abuf.length=" + nArray.length + ", cbuf.length=" + cArray.length);
                System.err.println("*** done dumping debug information");
            }
        }
        int n9 = 0;
        while (n9 < n2) {
            cArray[this.screenBase + n + (bl ? n9 : -n9)] = new char[this.size.width];
            nArray[this.screenBase + n + (bl ? n9 : -n9)] = new int[this.size.width];
            ++n9;
        }
        this.charArray = cArray;
        this.charAttributes = nArray;
        if (bl) {
            this.markLine(n, n3 - n + 1);
        } else {
            this.markLine(n4, n - n4 + 1);
        }
        if (this.scrollBar != null) {
            this.scrollBar.setValues(this.windowBase, this.size.height, 0, this.bufSize);
        }
    }

    public void deleteLine(int n) {
        int n2 = (n = this.checkBounds(n, 0, this.size.height - 1)) > this.bottomMargin ? this.size.height - 1 : (n < this.topMargin ? this.topMargin : this.bottomMargin + 1);
        System.arraycopy(this.charArray, this.screenBase + n + 1, this.charArray, this.screenBase + n, n2 - n - 1);
        System.arraycopy(this.charAttributes, this.screenBase + n + 1, this.charAttributes, this.screenBase + n, n2 - n - 1);
        this.charArray[this.screenBase + n2 - 1] = new char[this.size.width];
        this.charAttributes[this.screenBase + n2 - 1] = new int[this.size.width];
        this.markLine(n, n2 - n);
    }

    public void deleteArea(int n, int n2, int n3, int n4) {
        n = this.checkBounds(n, 0, this.size.width - 1);
        n2 = this.checkBounds(n2, 0, this.size.height - 1);
        char[] cArray = new char[n3];
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n4 && n2 + n5 < this.size.height) {
            System.arraycopy(cArray, 0, this.charArray[this.screenBase + n2 + n5], n, n3);
            System.arraycopy(nArray, 0, this.charAttributes[this.screenBase + n2 + n5], n, n3);
            ++n5;
        }
        this.markLine(n2, n4);
    }

    public void setCursorPosition(int n, int n2) {
        n = this.checkBounds(n, 0, this.size.width - 1);
        n2 = this.checkBounds(n2, 0, this.size.height - 1);
        this.markLine(this.cursorY, 1);
        this.cursorX = n < this.size.width ? n : this.size.width;
        this.cursorY = n2 < this.size.height ? n2 : this.size.height;
        this.markLine(n2, 1);
    }

    public void showCursor(boolean bl) {
        if (bl != this.showcursor) {
            this.markLine(this.cursorY, 1);
        }
        this.showcursor = bl;
    }

    public Dimension getCursorPosition() {
        return new Dimension(this.cursorX, this.cursorY);
    }

    public void setTopMargin(int n) {
        if (n > this.bottomMargin) {
            this.topMargin = this.bottomMargin;
            this.bottomMargin = n;
        } else {
            this.topMargin = n;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.size.height - 1) {
            this.bottomMargin = this.size.height - 1;
        }
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(int n) {
        if (n < this.topMargin) {
            this.bottomMargin = this.topMargin;
            this.topMargin = n;
        } else {
            this.bottomMargin = n;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.size.height - 1) {
            this.bottomMargin = this.size.height - 1;
        }
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBufferSize(int n) {
        if (n < this.size.height) {
            n = this.size.height;
        }
        if (n < this.maxBufSize) {
            int n2;
            char[][] cArray = new char[n][this.size.width];
            int[][] nArray = new int[n][this.size.width];
            int n3 = this.bufSize - n < 0 ? 0 : this.bufSize - n;
            int n4 = n2 = this.bufSize - n < 0 ? this.bufSize : n;
            if (this.charArray != null) {
                System.arraycopy(this.charArray, n3, cArray, 0, n2);
            }
            if (this.charAttributes != null) {
                System.arraycopy(this.charAttributes, n3, nArray, 0, n2);
            }
            this.charArray = cArray;
            this.charAttributes = nArray;
            this.bufSize = n2;
            this.windowBase = this.screenBase = this.bufSize - this.size.height;
        }
        this.maxBufSize = n;
        this.update[0] = true;
        this.redraw();
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public int getMaxBufferSize() {
        return this.maxBufSize;
    }

    public void setWindowBase(int n) {
        if (n > this.screenBase) {
            n = this.screenBase;
        } else if (n < 0) {
            n = 0;
        }
        this.windowBase = n;
        this.update[0] = true;
        this.redraw();
    }

    public int getWindowBase() {
        return this.windowBase;
    }

    public void setFont(Font font) {
        this.normalFont = font;
        super.setFont(this.normalFont);
        this.fm = this.getFontMetrics(font);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
            this.charDescent = this.fm.getDescent();
        }
        if (this.update != null) {
            this.update[0] = true;
        }
        this.redraw();
    }

    public void setScreenSize(int n, int n2) {
        int n3 = this.bufSize;
        if (n < 1 || n2 < 1) {
            return;
        }
        if (n2 > this.maxBufSize) {
            this.maxBufSize = n2;
        }
        if (n2 > this.bufSize) {
            this.bufSize = n2;
            this.screenBase = 0;
            this.windowBase = 0;
        }
        char[][] cArray = new char[this.bufSize][n];
        int[][] nArray = new int[this.bufSize][n];
        if (this.charArray != null && this.charAttributes != null) {
            int n4 = 0;
            while (n4 < n3 && n4 < this.bufSize) {
                System.arraycopy(this.charArray[n4], 0, cArray[n4], 0, n < this.size.width ? n : this.size.width);
                System.arraycopy(this.charAttributes[n4], 0, nArray[n4], 0, n < this.size.width ? n : this.size.width);
                ++n4;
            }
        }
        this.charArray = cArray;
        this.charAttributes = nArray;
        this.size = new Dimension(n, n2);
        this.topMargin = 0;
        this.bottomMargin = n2 - 1;
        this.update = new boolean[n2 + 1];
        this.update[0] = true;
    }

    public Dimension getScreenSize() {
        return this.size;
    }

    public void setResizeStrategy(int n) {
        this.resizeStrategy = n;
    }

    public int getRows() {
        return this.size.height;
    }

    public int getColumns() {
        return this.size.width;
    }

    public void setBorder(int n, boolean bl) {
        this.insets = n == 0 ? null : new Insets(n + 1, n + 1, n + 1, n + 1);
        this.raised = bl;
    }

    public void setScrollbar(Scrollbar scrollbar) {
        if (scrollbar == null) {
            return;
        }
        this.scrollBar = scrollbar;
        this.scrollBar.setValues(this.windowBase, this.size.height, 0, this.bufSize - this.size.height);
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                VDU.this.setWindowBase(adjustmentEvent.getValue());
            }
        });
    }

    public void markLine(int n, int n2) {
        n = this.checkBounds(n, 0, this.size.height - 1);
        int n3 = 0;
        while (n3 < n2 && n + n3 < this.size.height) {
            this.update[n + n3 + 1] = true;
            ++n3;
        }
    }

    public void redraw() {
        if (this.backingStore != null) {
            this.redraw(this.backingStore.getGraphics());
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void redraw(Graphics var1_1) {
        var2_2 = (super.getSize().width - this.size.width * this.charWidth) / 2;
        var3_3 = (super.getSize().height - this.size.height * this.charHeight) / 2;
        var4_4 = this.color[VDU.COLOR_FG_STD];
        var5_5 = this.color[VDU.COLOR_BG_STD];
        var1_1.setFont(this.normalFont);
        var6_6 = 0;
        while (var6_6 < this.size.height) {
            block21: {
                if (!this.update[0] && !this.update[var6_6 + 1]) break block21;
                this.update[var6_6 + 1] = false;
                var7_7 = 0;
                while (var7_7 < this.size.width) {
                    block22: {
                        var8_8 = 0;
                        var9_9 = this.charAttributes[this.windowBase + var6_6][var7_7];
                        var4_4 = this.getForeground();
                        var5_5 = this.getBackground();
                        if ((var9_9 & 1) != 0 && (var9_9 & 120) == 0 && (var9_9 & 1920) == 0) {
                            var4_4 = this.color[VDU.COLOR_FG_BOLD];
                        }
                        if ((var9_9 & 120) != 0) {
                            var4_4 = this.color[((var9_9 & 120) >> 3) - 1];
                        }
                        if ((var9_9 & 1920) != 0) {
                            var5_5 = this.color[((var9_9 & 1920) >> 7) - 1];
                        }
                        if ((var9_9 & 1) != 0) {
                            var4_4 = var4_4.equals(Color.black) != false && VDU.COLOR_FG_BOLD != 0 ? Color.gray : var4_4.brighter();
                        }
                        if ((var9_9 & 4) != 0) {
                            var10_10 = var5_5;
                            var5_5 = var4_4;
                            var4_4 = var10_10;
                        }
                        if (!this.sf.inSoftFont(this.charArray[this.windowBase + var6_6][var7_7])) ** GOTO lbl39
                        var1_1.setColor(var5_5);
                        var1_1.fillRect(var7_7 * this.charWidth + var2_2, var6_6 * this.charHeight + var3_3, this.charWidth, this.charHeight);
                        var1_1.setColor(var4_4);
                        this.sf.drawChar(var1_1, this.charArray[this.windowBase + var6_6][var7_7], var2_2 + var7_7 * this.charWidth, var6_6 * this.charHeight + var3_3, this.charWidth, this.charHeight);
                        if ((var9_9 & 2) == 0) break block22;
                        var1_1.drawLine(var7_7 * this.charWidth + var2_2, (var6_6 + 1) * this.charHeight - this.charDescent / 2 + var3_3, var7_7 * this.charWidth + this.charWidth + var2_2, (var6_6 + 1) * this.charHeight - this.charDescent / 2 + var3_3);
                        break block22;
lbl-1000:
                        // 1 sources

                        {
                            if (this.charArray[this.windowBase + var6_6][var7_7 + var8_8] < ' ') {
                                this.charArray[this.windowBase + var6_6][var7_7 + var8_8] = 32;
                            }
                            ++var8_8;
lbl39:
                            // 2 sources

                            ** while (var7_7 + var8_8 < this.size.width && this.charAttributes[this.windowBase + var6_6][var7_7 + var8_8] == var9_9 && !this.sf.inSoftFont((char)this.charArray[this.windowBase + var6_6][var7_7 + var8_8]))
                        }
lbl40:
                        // 1 sources

                        var1_1.setColor(var5_5);
                        var1_1.fillRect(var7_7 * this.charWidth + var2_2, var6_6 * this.charHeight + var3_3, var8_8 * this.charWidth, this.charHeight);
                        var1_1.setColor(var4_4);
                        var1_1.drawChars(this.charArray[this.windowBase + var6_6], var7_7, var8_8, var7_7 * this.charWidth + var2_2, (var6_6 + 1) * this.charHeight - this.charDescent + var3_3);
                        if ((var9_9 & 2) != 0) {
                            var1_1.drawLine(var7_7 * this.charWidth + var2_2, (var6_6 + 1) * this.charHeight - this.charDescent / 2 + var3_3, var7_7 * this.charWidth + var8_8 * this.charWidth + var2_2, (var6_6 + 1) * this.charHeight - this.charDescent / 2 + var3_3);
                        }
                        var7_7 += var8_8 - 1;
                    }
                    ++var7_7;
                }
            }
            ++var6_6;
        }
        if (this.showcursor && this.screenBase + this.cursorY >= this.windowBase && this.screenBase + this.cursorY < this.windowBase + this.size.height) {
            var1_1.setColor(this.color[VDU.COLOR_FG_STD]);
            var1_1.setXORMode(this.color[VDU.COLOR_BG_STD]);
            var1_1.fillRect(this.cursorX * this.charWidth + var2_2, (this.cursorY + this.screenBase - this.windowBase) * this.charHeight + var3_3, this.charWidth, this.charHeight);
            var1_1.setPaintMode();
        }
        if (this.windowBase <= this.selectBegin.y || this.windowBase <= this.selectEnd.y) {
            var7_7 = this.selectBegin.y - this.windowBase;
            var8_8 = this.selectEnd.y - this.selectBegin.y;
            if (var7_7 < 0) {
                var8_8 += var7_7;
                var7_7 = 0;
            }
            if (var8_8 > this.size.height) {
                var8_8 = this.size.height - var7_7;
            }
            var1_1.setXORMode(this.color[VDU.COLOR_BG_STD]);
            var1_1.fillRect(this.selectBegin.x * this.charWidth + var2_2, var7_7 * this.charHeight + var3_3, (var8_8 == 0 ? this.selectEnd.x - this.selectBegin.x : this.size.width - this.selectBegin.x) * this.charWidth, this.charHeight);
            if (var8_8 > 1) {
                var1_1.fillRect(0 + var2_2, (var7_7 + 1) * this.charHeight + var3_3, this.size.width * this.charWidth, (var8_8 - 1) * this.charHeight);
            }
            if (var8_8 > 0) {
                var1_1.fillRect(0 + var2_2, (var7_7 + var8_8) * this.charHeight + var3_3, this.selectEnd.x * this.charWidth, this.charHeight);
            }
            var1_1.setPaintMode();
        }
        if (this.insets != null) {
            var1_1.setColor(this.getBackground());
            --var2_2;
            --var3_3;
            var7_7 = this.insets.top - 1;
            while (var7_7 >= 0) {
                var1_1.draw3DRect(var2_2 - var7_7, var3_3 - var7_7, this.charWidth * this.size.width + 1 + var7_7 * 2, this.charHeight * this.size.height + 1 + var7_7 * 2, this.raised);
                --var7_7;
            }
        }
        this.update[0] = false;
    }

    public void paint(Graphics graphics) {
        if (this.backingStore == null) {
            Dimension dimension = super.getSize();
            this.backingStore = this.createImage(dimension.width, dimension.height);
            this.update[0] = true;
            this.redraw();
        }
        graphics.drawImage(this.backingStore, 0, 0, this);
    }

    public void setColorPrinting(boolean bl) {
        this.colorPrinting = bl;
    }

    public void print(Graphics graphics) {
        int n = 0;
        while (n <= this.size.height) {
            this.update[n] = true;
            ++n;
        }
        Color color = null;
        Color color2 = null;
        Color[] colorArray = null;
        int n2 = 0;
        if (!this.colorPrinting) {
            color = this.getForeground();
            color2 = this.getBackground();
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            n2 = COLOR_FG_BOLD;
            COLOR_FG_BOLD = 0;
            colorArray = this.color;
            this.color = new Color[]{Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.black, Color.white};
        }
        this.redraw(graphics);
        if (!this.colorPrinting) {
            this.color = colorArray;
            COLOR_FG_BOLD = n2;
            this.setForeground(color);
            this.setBackground(color2);
        }
    }

    private int checkBounds(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        if (this.insets != null) {
            n5 = this.insets.left + this.insets.right;
            n3 -= n5;
            n6 = this.insets.top + this.insets.bottom;
            n4 -= n6;
        }
        Font font = this.normalFont;
        String string = font.getName();
        int n7 = font.getStyle();
        this.fm = this.getFontMetrics(this.normalFont);
        if (this.fm != null) {
            this.charWidth = this.fm.charWidth('@');
            this.charHeight = this.fm.getHeight();
        }
        switch (this.resizeStrategy) {
            case 1: {
                this.size.height = n4 / this.charHeight;
                this.setScreenSize(n3 / this.charWidth, this.size.height);
                break;
            }
            case 2: {
                int n8 = n4 / this.size.height;
                int n9 = n3 / this.size.width;
                this.normalFont = new Font(string, n7, this.charHeight);
                this.fm = this.getFontMetrics(this.normalFont);
                if (this.fm.getHeight() < n8 || this.fm.charWidth('@') < n9) {
                    do {
                        this.normalFont = new Font(string, n7, ++this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.fm.getHeight() < n8 || this.fm.charWidth('@') < n9);
                }
                if (this.fm.getHeight() > n8 || this.fm.charWidth('@') > n9) {
                    do {
                        this.normalFont = new Font(string, n7, --this.charHeight);
                        this.fm = this.getFontMetrics(this.normalFont);
                    } while (this.charHeight > 1 && (this.fm.getHeight() > n8 || this.fm.charWidth('@') > n9));
                }
                if (this.charHeight <= 1) {
                    System.err.println("VDU: error during resize, resetting");
                    this.normalFont = font;
                    System.err.println("VDU: disabling font/screen resize");
                    this.resizeStrategy = 0;
                }
                this.setFont(this.normalFont);
                this.fm = this.getFontMetrics(this.normalFont);
                this.charWidth = this.fm.charWidth('@');
                this.charHeight = this.fm.getHeight();
                this.charDescent = this.fm.getDescent();
                break;
            }
        }
        this.backingStore = null;
        this.markLine(0, this.size.height);
    }

    public Dimension getSize() {
        int n = 0;
        int n2 = 0;
        if (this.insets != null) {
            n = this.insets.left + this.insets.right;
            n2 = this.insets.top + this.insets.bottom;
        }
        return new Dimension(this.size.width * this.charWidth + n, this.size.height * this.charHeight + n2);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void clearSelection() {
        this.selectBegin = new Point(0, 0);
        this.selectEnd = new Point(0, 0);
        this.selection = null;
    }

    public String getSelection() {
        return this.selection;
    }

    private boolean buttonCheck(int n, int n2) {
        return (n & n2) == n2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.buttonCheck(mouseEvent.getModifiers(), 16)) {
            int n = (super.getSize().width - this.size.width * this.charWidth) / 2;
            int n2 = (super.getSize().height - this.size.height * this.charHeight) / 2;
            int n3 = (mouseEvent.getX() - n) / this.charWidth;
            int n4 = (mouseEvent.getY() - n2) / this.charHeight + this.windowBase;
            int n5 = this.selectEnd.x;
            int n6 = this.selectEnd.y;
            if (n3 < this.selectBegin.x && n4 < this.selectBegin.y && n3 < this.selectEnd.x && n4 < this.selectEnd.y) {
                this.selectBegin.x = n3;
                this.selectBegin.y = n4;
            } else {
                this.selectEnd.x = n3;
                this.selectEnd.y = n4;
            }
            if (n5 != n3 || n6 != n4) {
                this.update[0] = true;
                this.redraw();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = (super.getSize().width - this.size.width * this.charWidth) / 2;
        int n2 = (super.getSize().height - this.size.height * this.charHeight) / 2;
        this.selectBegin.x = (mouseEvent.getX() - n) / this.charWidth;
        this.selectBegin.y = (mouseEvent.getY() - n2) / this.charHeight + this.windowBase;
        this.selectEnd.x = this.selectBegin.x;
        this.selectEnd.y = this.selectBegin.y;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.buttonCheck(mouseEvent.getModifiers(), 16)) {
            int n = (super.getSize().width - this.size.width * this.charWidth) / 2;
            int n2 = (super.getSize().height - this.size.height * this.charHeight) / 2;
            this.mouseDragged(mouseEvent);
            if (this.selectBegin.x == this.selectEnd.x && this.selectBegin.y == this.selectEnd.y) {
                this.update[0] = true;
                this.redraw();
                return;
            }
            this.selection = "";
            if (this.selectEnd.x < 0) {
                this.selectEnd.x = 0;
            }
            if (this.selectEnd.y < 0) {
                this.selectEnd.y = 0;
            }
            if (this.selectEnd.y >= this.charArray.length) {
                this.selectEnd.y = this.charArray.length - 1;
            }
            if (this.selectEnd.x >= this.charArray[0].length) {
                this.selectEnd.x = this.charArray[0].length - 1;
            }
            int n3 = this.selectBegin.y;
            while (n3 <= this.selectEnd.y) {
                int n4;
                int n5;
                n5 = n3 == this.selectBegin.y ? (n5 = this.selectBegin.x) : 0;
                n4 = n3 == this.selectEnd.y ? (n4 = this.selectEnd.x) : this.charArray[n3].length - 1;
                this.selection = this.selection + new String(this.charArray[n3]).substring(n5, n4);
                if (n4 == this.charArray[n3].length - 1) {
                    this.selection = this.selection + "\n";
                }
                ++n3;
            }
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.enableEvents(16L);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.enableEvents(16L);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            switch (mouseEvent.getID()) {
                case 500: {
                    this.mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 504: {
                    this.mouseListener.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 501: {
                    this.mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.mouseListener.mouseReleased(mouseEvent);
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mouseMotionListener != null) {
            switch (mouseEvent.getID()) {
                case 506: {
                    this.mouseMotionListener.mouseDragged(mouseEvent);
                    break;
                }
                case 503: {
                    this.mouseMotionListener.mouseMoved(mouseEvent);
                }
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.enableEvents(8L);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener != null) {
            switch (keyEvent.getID()) {
                case 401: {
                    this.keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    this.keyListener.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    this.keyListener.keyTyped(keyEvent);
                }
            }
        }
        if (keyEvent.getKeyCode() == 9 && keyEvent.getSource() == this) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener != null) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost(focusEvent);
                }
            }
        }
        super.processFocusEvent(focusEvent);
    }
}

