/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import de.mud.telnet.ScriptHandler;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class TelnetWrapper
extends TelnetProtocolHandler {
    private static final int debug = 0;
    protected ScriptHandler scriptHandler = new ScriptHandler();
    private Thread reader;
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    protected String host;
    protected int port = 23;
    protected Vector script = new Vector();
    private String prompt = null;

    public void connect(String string, int n) throws IOException {
        try {
            this.socket = new Socket(string, n);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.reset();
        }
        catch (Exception exception) {
            System.err.println("TelnetWrapper: " + exception);
            this.disconnect();
        }
    }

    public void disconnect() throws IOException {
        this.socket.close();
    }

    public void notifyEndOfRecord() {
    }

    public void login(String string, String string2) throws IOException {
        this.waitfor("login:");
        this.send(string);
        this.waitfor("Password:");
        this.send(string2);
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public String send(String string) throws IOException {
        this.write((string + "\n").getBytes());
        if (this.prompt != null) {
            return this.waitfor(this.prompt);
        }
        return null;
    }

    public String waitfor(String string) throws IOException {
        this.scriptHandler.setup(string);
        byte[] byArray = new byte[256];
        int n = 0;
        String string2 = "";
        while (n >= 0) {
            n = this.read(byArray);
            if (n <= 0) continue;
            string2 = string2 + new String(byArray, 0, n);
            if (!this.scriptHandler.match(byArray, n)) continue;
            return string2;
        }
        return null;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n > 0) {
            n = this.negotiate(byArray, n);
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public String getTerminalType() {
        return "dumb";
    }

    public Dimension getWindowSize() {
        return new Dimension(80, 24);
    }

    public void setLocalEcho(boolean bl) {
    }
}

