/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.SshCrypto;
import de.mud.ssh.SshMisc;
import java.io.IOException;

class SshPacket {
    private static final boolean debug = false;
    private byte[] packet_length_array = new byte[4];
    private int packet_length = 0;
    private byte[] padding = null;
    private byte packet_type;
    private short last_packet_type;
    private byte[] data = null;
    private byte[] crc_array = new byte[4];
    private byte[] block = null;
    private byte[] encryptedBlock = null;
    private byte[] decryptedBlock = null;
    public boolean toBeFinished = false;
    public byte[] unfinishedBuffer;
    public int positionInUnfinishedBuffer;
    private int position = 0;
    private int phase_packet = 0;
    private final int PHASE_packet_length = 0;
    private final int PHASE_block = 1;

    public SshPacket(byte by, byte[] byArray, boolean bl, SshCrypto sshCrypto) throws IOException {
        this.data = byArray;
        this.packet_type = by;
        this.packet_length = this.data != null ? this.data.length + 5 : 5;
        this.packet_length_array[3] = (byte)(this.packet_length & 0xFF);
        this.packet_length_array[2] = (byte)(this.packet_length >> 8 & 0xFF);
        this.packet_length_array[1] = (byte)(this.packet_length >> 16 & 0xFF);
        this.packet_length_array[0] = (byte)(this.packet_length >> 24 & 0xFF);
        this.padding = new byte[8 - this.packet_length % 8];
        if (!bl) {
            int n = 0;
            while (n < this.padding.length) {
                this.padding[n] = 0;
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.padding.length) {
                this.padding[n] = SshMisc.getNotZeroRandomByte();
                ++n;
            }
        }
        byte[] byArray2 = new byte[this.packet_length + this.padding.length - 4];
        int n = 0;
        int n2 = 0;
        while (n2 < this.padding.length) {
            byArray2[n++] = this.padding[n2];
            ++n2;
        }
        byArray2[n++] = this.packet_type;
        if (this.packet_length > 5) {
            int n3 = 0;
            while (n3 < this.data.length) {
                byArray2[n++] = this.data[n3];
                ++n3;
            }
        }
        long l = 0L;
        l = SshMisc.crc32(byArray2, byArray2.length);
        this.crc_array[3] = (byte)(l & 0xFFL);
        this.crc_array[2] = (byte)(l >> 8 & 0xFFL);
        this.crc_array[1] = (byte)(l >> 16 & 0xFFL);
        this.crc_array[0] = (byte)(l >> 24 & 0xFFL);
        this.setBlock();
        if (bl) {
            sshCrypto.encrypt(this.block);
        }
        this.encryptedBlock = this.block;
    }

    private void setBlock() throws IOException {
        this.block = new byte[this.packet_length + this.padding.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.padding.length) {
            this.block[n++] = this.padding[n2];
            ++n2;
        }
        this.block[n++] = this.packet_type;
        if (this.packet_length > 5) {
            int n3 = 0;
            while (n3 < this.data.length) {
                this.block[n++] = this.data[n3];
                ++n3;
            }
        }
        int n4 = 0;
        while (n4 < this.crc_array.length) {
            this.block[n++] = this.crc_array[n4];
            ++n4;
        }
    }

    public byte[] getBytes() throws IOException {
        return SshMisc.addArrayOfBytes(this.packet_length_array, this.encryptedBlock);
    }

    public byte[] getData() throws IOException {
        return this.data;
    }

    public byte getType() throws IOException {
        return this.packet_type;
    }

    public SshPacket getPacketfromBytes(byte[] byArray, int n, int n2, boolean bl, SshCrypto sshCrypto) throws IOException {
        int n3 = n;
        while (n3 < n2) {
            byte by = byArray[n3++];
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position] = by;
                    if (++this.position < 4) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    this.position = 0;
                    ++this.phase_packet;
                    break;
                }
                case 1: {
                    if (this.position == 0) {
                        int n4 = 8 * (this.packet_length / 8 + 1);
                        this.block = new byte[n4];
                    }
                    this.block[this.position] = by;
                    if (++this.position < this.block.length) break;
                    if (n2 > n3) {
                        this.toBeFinished = true;
                        this.unfinishedBuffer = byArray;
                        this.positionInUnfinishedBuffer = n3;
                    } else {
                        this.toBeFinished = false;
                    }
                    this.position = 0;
                    this.phase_packet = 0;
                    if (bl) {
                        sshCrypto.decrypt(this.block);
                    }
                    this.decryptedBlock = this.block;
                    this.setPacketFromDecryptedBlock();
                    if (!this.checkCrc()) {
                        System.err.println("SshPacket: Crc Error !!");
                        return null;
                    }
                    return this;
                }
            }
        }
        this.toBeFinished = false;
        return null;
    }

    private boolean checkCrc() {
        byte[] byArray = new byte[4];
        long l = SshMisc.crc32(this.decryptedBlock, this.decryptedBlock.length - 4);
        byArray[3] = (byte)(l & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[1] = (byte)(l >> 16 & 0xFFL);
        byArray[0] = (byte)(l >> 24 & 0xFFL);
        if (byArray[3] != this.crc_array[3]) {
            return false;
        }
        if (byArray[2] != this.crc_array[2]) {
            return false;
        }
        if (byArray[1] != this.crc_array[1]) {
            return false;
        }
        return byArray[0] == this.crc_array[0];
    }

    private void setPacketFromDecryptedBlock() throws IOException {
        int n;
        int n2 = 0;
        int n3 = 8 - this.packet_length % 8;
        this.padding = new byte[n3];
        if (this.decryptedBlock.length != n3 + this.packet_length) {
            System.out.println("???");
        }
        int n4 = 0;
        while (n4 < this.padding.length) {
            this.padding[n4] = this.decryptedBlock[n2++];
            ++n4;
        }
        this.packet_type = this.decryptedBlock[n2++];
        if (this.packet_length > 5) {
            this.data = new byte[this.packet_length - 5];
            n = 0;
            while (n < this.data.length) {
                this.data[n] = this.decryptedBlock[n2++];
                ++n;
            }
        } else {
            this.data = null;
        }
        n = 0;
        while (n < this.crc_array.length) {
            this.crc_array[n] = this.decryptedBlock[n2++];
            ++n;
        }
    }
}

