/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.AppletListener;
import de.mud.jta.event.ConfigurationListener;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Menu;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Vector;

public class URLFilter
extends Plugin
implements FilterPlugin,
VisualPlugin,
Runnable {
    private static final int debug = 0;
    protected Vector protocols = new Vector();
    protected List urlList = new List(4, false);
    protected Panel urlPanel;
    protected Menu urlMenu;
    protected PipedInputStream pin;
    protected PipedOutputStream pout;
    protected AppletContext context;
    private Vector urlCache = new Vector();
    protected FilterPlugin source;

    public URLFilter(PluginBus pluginBus, final String string) {
        super(pluginBus, string);
        this.urlPanel = new Panel(new BorderLayout());
        this.urlList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URLFilter.this.showURL(actionEvent.getActionCommand());
            }
        });
        this.urlPanel.add("Center", this.urlList);
        Panel panel = new Panel(new GridLayout(3, 1));
        Button button = new Button("Clear List");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URLFilter.this.urlCache.removeAllElements();
                URLFilter.this.urlList.removeAll();
            }
        });
        panel.add(button);
        button = new Button("Remove URL");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = URLFilter.this.urlList.getSelectedItem();
                if (string != null) {
                    URLFilter.this.urlCache.removeElement(string);
                    URLFilter.this.urlList.remove(string);
                }
            }
        });
        panel.add(button);
        button = new Button("Show URL");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = URLFilter.this.urlList.getSelectedItem();
                if (string != null) {
                    URLFilter.this.showURL(string);
                }
            }
        });
        panel.add(button);
        this.urlPanel.add("East", panel);
        pluginBus.registerPluginListener(new AppletListener(){

            public void setApplet(Applet applet) {
                URLFilter.this.context = applet.getAppletContext();
            }
        });
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                String string2 = pluginConfig.getProperty("protocols", string);
                if (string2 != null) {
                    int n = -1;
                    int n2 = string2.indexOf(44);
                    while (n2 >= 0) {
                        URLFilter.this.protocols.addElement(string2.substring(n + 1, n2));
                        n = n2;
                        n2 = string2.indexOf(44, n + 1);
                    }
                    URLFilter.this.protocols.addElement(string2.substring(n + 1));
                } else {
                    URLFilter.this.protocols.addElement("http");
                    URLFilter.this.protocols.addElement("ftp");
                    URLFilter.this.protocols.addElement("gopher");
                    URLFilter.this.protocols.addElement("file");
                }
            }
        });
        this.pin = new PipedInputStream();
        this.pout = new PipedOutputStream();
        try {
            this.pout.connect(this.pin);
        }
        catch (IOException iOException) {
            System.err.println("URLFilter: error installing recognizer: " + iOException);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            int n;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(this.pin)));
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.whitespaceChars(0, 31);
            streamTokenizer.ordinaryChar(34);
            streamTokenizer.ordinaryChar(60);
            streamTokenizer.ordinaryChar(62);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.ordinaryChar(58);
            while ((n = streamTokenizer.nextToken()) != -1) {
                String string;
                if (n != -3 || !this.protocols.contains(string = streamTokenizer.sval.toLowerCase()) || streamTokenizer.nextToken() != 58 || streamTokenizer.nextToken() != 47) continue;
                String string2 = string + ":/";
                while ((n = streamTokenizer.nextToken()) == -3 || n == 47) {
                    string2 = n == -3 ? string2 + streamTokenizer.sval : string2 + (char)n;
                }
                if (string2.endsWith(".")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (this.urlCache.contains(string2)) continue;
                this.urlCache.addElement(string2);
                this.urlList.add(string2);
                this.urlList.makeVisible(this.urlList.getItemCount() - 1);
                System.out.println("URLFilter: found \"" + string2 + "\"");
            }
        }
        catch (IOException iOException) {
            System.err.println("URLFilter: recognition aborted: " + iOException);
        }
    }

    protected void showURL(String string) {
        if (this.context == null) {
            System.err.println("URLFilter: no url-viewer available\n");
            return;
        }
        try {
            this.context.showDocument(new URL(string), "URLFilter");
        }
        catch (Exception exception) {
            System.err.println("URLFilter: cannot load url: " + exception);
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (n > 0) {
            this.pout.write(byArray, 0, n);
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
    }

    public Component getPluginVisual() {
        return this.urlPanel;
    }

    public Menu getPluginMenu() {
        return this.urlMenu;
    }
}

