/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.FocusStatus;
import de.mud.jta.event.LocalEchoListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusListener;
import de.mud.jta.event.TerminalTypeListener;
import de.mud.jta.event.WindowSizeListener;
import de.mud.terminal.vt320;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Terminal
extends Plugin
implements FilterPlugin,
VisualTransferPlugin,
ClipboardOwner,
Runnable {
    private static final boolean personalJava = false;
    private static final int debug = 0;
    protected vt320 terminal;
    protected Panel tPanel;
    protected Menu menu;
    private Thread reader = null;
    private Hashtable colors = new Hashtable();
    protected FilterPlugin source;

    public Terminal(final PluginBus pluginBus, String string) {
        super(pluginBus, string);
        MenuItem menuItem;
        this.colors.put("black", Color.black);
        this.colors.put("red", Color.red);
        this.colors.put("green", Color.green);
        this.colors.put("yellow", Color.yellow);
        this.colors.put("blue", Color.blue);
        this.colors.put("magenta", Color.magenta);
        this.colors.put("orange", Color.orange);
        this.colors.put("pink", Color.pink);
        this.colors.put("cyan", Color.cyan);
        this.colors.put("white", Color.white);
        this.colors.put("gray", Color.white);
        this.menu = new Menu("Terminal");
        Menu menu = new Menu("Foreground");
        Menu menu2 = new Menu("Background");
        Enumeration enumeration = this.colors.keys();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.terminal.setForeground((Color)Terminal.this.colors.get(actionEvent.getActionCommand()));
                Terminal.this.terminal.repaint();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.terminal.setBackground((Color)Terminal.this.colors.get(actionEvent.getActionCommand()));
                Terminal.this.terminal.repaint();
            }
        };
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            menuItem = new MenuItem(string2);
            menu.add(menuItem);
            menuItem.addActionListener(actionListener);
            menuItem = new MenuItem(string2);
            menu2.add(menuItem);
            menuItem.addActionListener(actionListener2);
        }
        this.menu.add(menu);
        this.menu.add(menu2);
        menuItem = new MenuItem("Smaller Font");
        this.menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container container = Terminal.this.tPanel.getParent();
                    if (container instanceof Frame) {
                        ((Frame)container).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        menuItem = new MenuItem("Larger Font");
        this.menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container container = Terminal.this.tPanel.getParent();
                    if (container instanceof Frame) {
                        ((Frame)container).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        menuItem = new MenuItem("Buffer +50");
        this.menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.terminal.setBufferSize(Terminal.this.terminal.getBufferSize() + 50);
            }
        });
        menuItem = new MenuItem("Buffer -50");
        this.menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.terminal.setBufferSize(Terminal.this.terminal.getBufferSize() - 50);
            }
        });
        this.menu.addSeparator();
        menuItem = new MenuItem("Reset Terminal");
        this.menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Terminal.this.terminal.reset();
            }
        });
        this.terminal = new vt320(){

            public void write(byte[] byArray) {
                try {
                    Terminal.this.write(byArray);
                }
                catch (IOException iOException) {
                    Terminal.this.reader = null;
                }
            }
        };
        this.tPanel = new Panel(new BorderLayout()){

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public void print(Graphics graphics) {
                Terminal.this.terminal.print(graphics);
            }
        };
        this.tPanel.add("Center", this.terminal);
        this.terminal.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Terminal.this.terminal.setCursor(Cursor.getPredefinedCursor(2));
                pluginBus.broadcast(new FocusStatus(Terminal.this, focusEvent));
            }

            public void focusLost(FocusEvent focusEvent) {
                Terminal.this.terminal.setCursor(Cursor.getDefaultCursor());
                pluginBus.broadcast(new FocusStatus(Terminal.this, focusEvent));
            }
        });
        pluginBus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                if (Terminal.this.reader == null) {
                    Terminal.this.reader = new Thread(Terminal.this);
                    Terminal.this.reader.start();
                }
            }

            public void offline() {
                if (Terminal.this.reader != null) {
                    Terminal.this.reader = null;
                }
            }
        });
        pluginBus.registerPluginListener(new TerminalTypeListener(){

            public String getTerminalType() {
                return Terminal.this.terminal.getTerminalID();
            }
        });
        pluginBus.registerPluginListener(new WindowSizeListener(){

            public Dimension getWindowSize() {
                return Terminal.this.terminal.getScreenSize();
            }
        });
        pluginBus.registerPluginListener(new LocalEchoListener(){

            public void setLocalEcho(boolean bl) {
                Terminal.this.terminal.setLocalEcho(bl);
            }
        });
        pluginBus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig pluginConfig) {
                Terminal.this.configure(pluginConfig);
            }
        });
        pluginBus.registerPluginListener(new ReturnFocusListener(){

            public void returnFocus() {
                Terminal.this.terminal.requestFocus();
            }
        });
    }

    private void configure(PluginConfig pluginConfig) {
        Object object;
        String string = pluginConfig.getProperty("Terminal", this.id, "foreground");
        if (string != null) {
            this.terminal.setForeground(Color.decode(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "background")) != null) {
            this.terminal.setBackground(Color.decode(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "print.color")) != null) {
            try {
                this.terminal.setColorPrinting(Boolean.valueOf(string));
            }
            catch (Exception exception) {
                this.error("Terminal.color.print: must be either true or false, not " + string);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "colorSet")) != null) {
            object = new Properties();
            try {
                ((Properties)object).load(this.getClass().getResourceAsStream(string));
            }
            catch (Exception exception) {
                try {
                    ((Properties)object).load(new URL(string).openStream());
                }
                catch (Exception exception2) {
                    this.error("cannot find colorSet: " + string);
                    this.error("resource access failed: " + exception);
                    this.error("URL access failed: " + exception2);
                    object = null;
                }
            }
            if (object != null) {
                Color[] colorArray = this.terminal.getColorSet();
                int n = 0;
                while (n < 8) {
                    string = ((Properties)object).getProperty("color" + n);
                    if (string != null) {
                        if (this.colors.get(string) != null) {
                            colorArray[n] = (Color)this.colors.get(string);
                        } else {
                            try {
                                colorArray[n] = Color.getColor(string) != null ? Color.getColor(string) : Color.decode(string);
                            }
                            catch (Exception exception) {
                                this.error("ignoring unknown color code: " + string);
                            }
                        }
                    }
                    ++n;
                }
                this.terminal.setColorSet(colorArray);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "border")) != null) {
            object = string;
            boolean bl = false;
            string = pluginConfig.getProperty("Terminal", this.id, "borderRaised");
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
            this.terminal.setBorder(Integer.parseInt((String)object), bl);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "scrollBar")) != null && !((String)(object = string)).equals("none")) {
            if (!((String)object).equals("East") && !((String)object).equals("West")) {
                object = "East";
            }
            Scrollbar scrollbar = new Scrollbar();
            this.tPanel.add((String)object, scrollbar);
            this.terminal.setScrollbar(scrollbar);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "id")) != null) {
            this.terminal.setTerminalID(string);
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "buffer")) != null) {
            this.terminal.setBufferSize(Integer.parseInt(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "size")) != null) {
            try {
                int n = string.indexOf(44);
                int n2 = Integer.parseInt(string.substring(1, n).trim());
                int n3 = Integer.parseInt(string.substring(n + 1, string.length() - 1).trim());
                this.terminal.setScreenSize(n2, n3);
            }
            catch (Exception exception) {
                this.error("screen size is wrong: " + string);
                this.error("error: " + exception);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "resize")) != null) {
            if (string.equals("font")) {
                this.terminal.setResizeStrategy(2);
            } else if (string.equals("screen")) {
                this.terminal.setResizeStrategy(1);
            } else {
                this.terminal.setResizeStrategy(0);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "font")) != null) {
            String string2;
            String string3 = string;
            int n = 0;
            int n4 = 12;
            string = pluginConfig.getProperty("Terminal", this.id, "fontSize");
            if (string != null) {
                n4 = Integer.parseInt(string);
            }
            if ((string2 = pluginConfig.getProperty("Terminal", this.id, "fontStyle")) == null || string2.equals("plain")) {
                n = 0;
            } else if (string2.equals("bold")) {
                n = 1;
            } else if (string2.equals("italic")) {
                n = 2;
            } else if (string2.equals("bold+italic")) {
                n = 3;
            }
            this.terminal.setFont(new Font(string3, n, n4));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "keyCodes")) != null) {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getResourceAsStream(string));
            }
            catch (Exception exception) {
                try {
                    properties.load(new URL(string).openStream());
                }
                catch (Exception exception3) {
                    this.error("cannot find keyCodes: " + string);
                    this.error("resource access failed: " + exception);
                    this.error("URL access failed: " + exception3);
                    properties = null;
                }
            }
            if (properties != null) {
                this.terminal.setKeyCodes(properties);
            }
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "VMS")) != null) {
            this.terminal.setVMS(Boolean.valueOf(string));
        }
        if ((string = pluginConfig.getProperty("Terminal", this.id, "IBM")) != null) {
            this.terminal.setIBMCharset(Boolean.valueOf(string));
        }
        this.tPanel.setBackground(this.terminal.getBackground());
    }

    public void run() {
        byte[] byArray = new byte[256];
        int n = 0;
        while (n >= 0) {
            try {
                n = this.read(byArray);
                if (n <= 0) continue;
                this.terminal.putString(new String(byArray, 0, n));
            }
            catch (IOException iOException) {
                this.reader = null;
                break;
            }
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) throws IOException {
        return this.source.read(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
    }

    public Component getPluginVisual() {
        return this.tPanel;
    }

    public Menu getPluginMenu() {
        return this.menu;
    }

    public void copy(Clipboard clipboard) {
        String string = this.terminal.getSelection();
        if (string == null) {
            return;
        }
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
    }

    public void paste(Clipboard clipboard) {
        if (clipboard == null) {
            return;
        }
        Transferable transferable = clipboard.getContents(this);
        try {
            byte[] byArray = ((String)transferable.getTransferData(DataFlavor.stringFlavor)).getBytes();
            try {
                this.write(byArray);
            }
            catch (IOException iOException) {
                this.reader = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.terminal.clearSelection();
    }
}

