/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.event.EndOfRecordRequest;
import de.mud.jta.event.LocalEchoRequest;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.TerminalTypeRequest;
import de.mud.jta.event.WindowSizeRequest;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;

public class Telnet
extends Plugin
implements FilterPlugin {
    protected FilterPlugin source;
    protected TelnetProtocolHandler handler;
    private static final int debug = 0;

    public Telnet(final PluginBus pluginBus, String string) {
        super(pluginBus, string);
        this.handler = new TelnetProtocolHandler(){

            public String getTerminalType() {
                return (String)pluginBus.broadcast(new TerminalTypeRequest());
            }

            public Dimension getWindowSize() {
                return (Dimension)pluginBus.broadcast(new WindowSizeRequest());
            }

            public void setLocalEcho(boolean bl) {
                pluginBus.broadcast(new LocalEchoRequest(bl));
            }

            public void notifyEndOfRecord() {
                pluginBus.broadcast(new EndOfRecordRequest());
            }

            public void write(byte[] byArray) throws IOException {
                Telnet.this.source.write(byArray);
            }
        };
        pluginBus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                Telnet.this.handler.reset();
                try {
                    Telnet.this.handler.startup();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                pluginBus.broadcast(new LocalEchoRequest(true));
            }

            public void offline() {
                Telnet.this.handler.reset();
                pluginBus.broadcast(new LocalEchoRequest(true));
            }
        });
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (n > 0) {
            n = this.handler.negotiate(byArray, n);
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.handler.transpose(byArray);
    }
}

