/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Common;
import de.mud.jta.Plugin;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.FocusStatusListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusRequest;
import de.mud.jta.event.SocketRequest;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintJob;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Main {
    private static final int debug = 0;
    private static final boolean personalJava = false;
    private static Plugin focussedPlugin;
    private static Clipboard clipboard;
    static /* synthetic */ Class class$de$mud$jta$Main;

    public static void main(String[] stringArray) {
        Object object;
        MenuContainer menuContainer;
        Object object2;
        String string;
        Properties properties = new Properties();
        try {
            properties.load((class$de$mud$jta$Main == null ? (class$de$mud$jta$Main = Main.class$("de.mud.jta.Main")) : class$de$mud$jta$Main).getResourceAsStream("/de/mud/jta/default.conf"));
        }
        catch (IOException iOException) {
            System.err.println("jta: cannot load default.conf");
        }
        String string2 = Main.parseOptions(properties, stringArray);
        if (string2 != null) {
            System.err.println(string2);
            System.err.println("usage: de.mud.jta.Main [-plugins pluginlist] [-addplugin plugin] [-config url_or_file] [-term id] [host [port]]");
            System.exit(0);
        }
        if ((string = properties.getProperty("Main.config")) != null) {
            try {
                properties.load(new URL(string).openStream());
            }
            catch (IOException iOException) {
                try {
                    properties.load(new FileInputStream(string));
                }
                catch (Exception exception) {
                    System.err.println("jta: cannot load " + string);
                }
            }
        }
        final String string3 = properties.getProperty("Socket.host");
        final String string4 = properties.getProperty("Socket.port");
        final Frame frame = new Frame("jta: " + string3 + (string4.equals("23") ? "" : " " + string4));
        try {
            clipboard = frame.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            System.err.println("jta: system clipboard access denied");
            System.err.println("jta: copy & paste only within the JTA");
            clipboard = new Clipboard("de.mud.jta.Main");
        }
        final Common common = new Common(properties);
        common.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                frame.setTitle("jta: " + string3 + (string4.equals("23") ? "" : " " + string4));
            }

            public void offline() {
                frame.setTitle("jta: offline");
            }
        });
        common.registerPluginListener(new FocusStatusListener(){

            public void pluginGainedFocus(Plugin plugin) {
                focussedPlugin = plugin;
            }

            public void pluginLostFocus(Plugin plugin) {
            }
        });
        Hashtable hashtable = common.getComponents();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            menuContainer = (Component)hashtable.get(object2);
            if (properties.getProperty("layout." + (String)object2) == null) {
                System.err.println("jta: no layout property set for '" + (String)object2 + "'");
                frame.add("South", (Component)menuContainer);
                continue;
            }
            frame.add(properties.getProperty("layout." + (String)object2), (Component)menuContainer);
        }
        object2 = new MenuBar();
        menuContainer = new Menu("File");
        ((MenuItem)((Object)menuContainer)).setShortcut(new MenuShortcut(72, true));
        MenuItem menuItem = new MenuItem("Connect");
        ((Menu)menuContainer).add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                common.broadcast(new SocketRequest(string3, Integer.parseInt(string4)));
            }
        });
        menuItem = new MenuItem("Disconnect");
        ((Menu)menuContainer).add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                common.broadcast(new SocketRequest());
            }
        });
        ((Menu)menuContainer).add(new MenuItem("-"));
        menuItem = new MenuItem("Print");
        ((Menu)menuContainer).add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (common.getComponents().get("Terminal") != null) {
                    PrintJob printJob = frame.getToolkit().getPrintJob(frame, "JTA Terminal", null);
                    if (printJob == null) {
                        return;
                    }
                    ((Component)common.getComponents().get("Terminal")).print(printJob.getGraphics());
                    printJob.end();
                }
            }
        });
        ((Menu)menuContainer).add(new MenuItem("-"));
        menuItem = new MenuItem("Exit");
        ((Menu)menuContainer).add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                frame.dispose();
                System.exit(0);
            }
        });
        ((MenuBar)object2).add((Menu)menuContainer);
        Menu menu = new Menu("Edit");
        menu.setShortcut(new MenuShortcut(72, true));
        menuItem = new MenuItem("Copy");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).copy(clipboard);
                }
            }
        });
        menuItem = new MenuItem("Paste");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).paste(clipboard);
                }
            }
        });
        ((MenuBar)object2).add(menu);
        Hashtable hashtable2 = common.getMenus();
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            ((MenuBar)object2).add((Menu)hashtable2.get(object));
        }
        object = new Menu("Help");
        menuItem = new MenuItem("About");
        ((Menu)object).add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dialog dialog = new Dialog(frame, "About JTA", true);
                dialog.add("Center", new Label("Copyright (c) 1996-2000 Matthias L Jugel, Marcus Mei\u00dfner"));
                Button button = new Button("Close");
                button.addActionListener(new ActionListener(this, dialog){
                    private final /* synthetic */ Dialog val$d;
                    private final /* synthetic */ 9 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$d = dialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$d.dispose();
                    }
                });
                dialog.add("South", button);
                dialog.pack();
                dialog.setResizable(false);
                dialog.show();
            }
        });
        ((MenuBar)object2).setHelpMenu((Menu)object);
        frame.setMenuBar((MenuBar)object2);
        frame.pack();
        frame.show();
        common.broadcast(new SocketRequest(string3, Integer.parseInt(string4)));
        common.broadcast(new ReturnFocusRequest());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseOptions(Properties properties, String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-config")) {
                if (stringArray[n + 1].startsWith("-")) return "missing parameter for -config";
                ((Hashtable)properties).put("Main.config", stringArray[++n]);
            } else if (stringArray[n].equals("-plugins")) {
                if (stringArray[n + 1].startsWith("-")) return "missing parameter for -plugins";
                ((Hashtable)properties).put("plugins", stringArray[++n]);
            } else if (stringArray[n].equals("-addplugin")) {
                if (stringArray[n + 1].startsWith("-")) return "missing parameter for -addplugin";
                ((Hashtable)properties).put("plugins", stringArray[++n] + "," + ((Hashtable)properties).get("plugins"));
            } else if (stringArray[n].equals("-term")) {
                if (stringArray[n + 1].startsWith("-")) return "missing parameter for -term";
                ((Hashtable)properties).put("Terminal.id", stringArray[++n]);
            } else if (!bl) {
                ((Hashtable)properties).put("Socket.host", stringArray[n]);
                bl = true;
            } else {
                if (!bl || bl2) return "unknown parameter '" + stringArray[n] + "'";
                ((Hashtable)properties).put("Socket.port", stringArray[n]);
                bl2 = true;
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

