# webmin-lib.pl
# Common functions for configuring miniserv

do '../web-lib.pl';
&init_config("webmin");

@cs_codes = ( 'cs_page', 'cs_text', 'cs_table', 'cs_header', 'cs_link' );
@cs_names = map { $text{$_} } @cs_codes;

sub setup_ca
{
local $conf = `cat ../acl/openssl.cnf`;
local $acl = "$config_directory/acl";
$conf =~ s/DIRECTORY/$acl/g;
open(CONF, ">$acl/openssl.cnf");
print CONF $conf;
close(CONF);
open(INDEX, ">$acl/index.txt");
close(INDEX);
open(SERIAL, ">$acl/serial");
print SERIAL "011E\n";
close(SERIAL);
mkdir("$acl/newcerts", 0755);
$miniserv{'ca'} = "$acl/ca.pem";
}

1;
