#!/usr/local/bin/perl
# index.cgi
# Display a menu of different kinds of options

require './squid-lib.pl';

# Check for squid config file
if (!-r $config{'squid_conf'}) {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>";
	print &text('index_msgnoconfig',$config{'squid_conf'},
		$module_name);
	print "\n<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

# Check for the squid executable
if (!&has_command($config{'squid_path'})) {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>";
	print &text('index_msgnoexe',$config{'squid_path'},
		$module_name);
	print "\n<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

# Check the version number
$ver = `$config{'squid_path'} -v 2>&1`;
if ($ver =~ /(1\.1)\.\d+/ || $ver =~ /(1)\.NOVM/ ||
    $ver =~ /(2\.0)\./ || $ver =~ /(2\.1)\./ || $ver =~ /(2\.2)\./ ||
    $ver =~ /(2\.3)\./) {
	# Save version number
	open(VERSION, ">$module_config_directory/version");
	print VERSION $1,"\n";
	close(VERSION);
	$squid_version = $1;
	}
else {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>";
	print $text{'index_msgnosupported'};
	print "\n<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

# Check for the cache directory
$conf = &get_config();
if (@cachestruct = &find_config("cache_dir", $conf)) {
	if ($squid_version >= 2.3) {
		@caches = map { $_->{'values'}->[1] } @cachestruct;
		}
	else {
		@caches = map { $_->{'values'}->[0] } @cachestruct;
		}
	}
else { @caches = ( $config{'cache_dir'} ); }
foreach $c (@caches) {
	if (!-d $c || !-d "$c/00") { $not_init++; }
	}
if ($not_init) {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p><center>\n";
	if (@caches > 1) {
		print &text('index_msgnodir1', join(", ", @caches));
		}
	else {
		print &text('index_msgnodir2', $cache);
		}
	print $text{'index_msgnodir3'},"<br>\n";
	print "<form action=init_cache.cgi>\n";
	print "<input type=submit value=\"$text{'index_buttinit'}\">\n";
	if (!&find_config("cache_effective_user", $conf)) {
		print $text{'index_asuser'}," ",&unix_user_input("user"),
			"<p>\n";
		}
	else {
		print "<input type=hidden name=nouser value=1>\n";
		}
	print "<input type=hidden name=caches value=\"",
		join(" ",@caches),"\">\n";
	print "</form></center>\n";
	print "<hr>\n";
	}
else {
	&header($text{'index_header'}, "", "intro",
		1, 1, 0, &restart_button());
	print "<hr>\n";
	}
@otitles = ( $text{'index_portsnets'}, $text{'index_othercaches'}, 
             $text{'index_musage'}, $text{'index_logging'},
	     $text{'index_copts'}, $text{'index_hprogs'}, 
             $text{'index_actrl'}, $text{'index_admopts'},
	     ($squid_version < 2 ? ($text{'index_proxyauth'}) : ()),
	     $text{'index_miscopt'}, $text{'index_cms'},
	     $text{'index_rebuild'} );
@olinks =  ( "edit_ports.cgi", "edit_icp.cgi", "edit_mem.cgi", "edit_logs.cgi",
	     "edit_cache.cgi", "edit_progs.cgi", "edit_acl.cgi",
	     "edit_admin.cgi", ($squid_version < 2 ? ("edit_auth.cgi") : ()),
	     "edit_misc.cgi", "cachemgr.cgi", "clear.cgi" );
@oicons =  map { $t=$_; $t=~s/cgi/gif/; $t=~s/edit_//; "images/$t" } @olinks;
&icons_table(\@olinks, \@otitles, \@oicons);

print "<hr>\n";
&footer("/", $text{'index_return'});

