#!/usr/local/bin/perl
# user_filesys.cgi
# List all filesystems for which some user has quotas

require './quota-lib.pl';
&ReadParse();
$u = $in{'user'};
&can_edit_user($u) ||
	&error(&text('user_filesys_2', $u));
&header($text{'user_filesys_0'}, "", "user_filesys");
print "<hr>\n";

foreach $f (&list_filesystems()) {
	if ($f->[4]%2 && $f->[5] && &can_edit_filesys($f->[0])) {
		push(@fslist, $f->[0]);
		$fslist{$f->[0]}++;
		}
	}

$n = &user_filesystems($u);
if ($n) {
	print "<h3>",&text('user_filesys_3', $u),"</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><br></td>\n";
	print "<td colspan=3 align=center><b>$text{'user_filesys_4'}</b></td>\n";
	print "<td colspan=3 align=center><b>$text{'user_filesys_5'}</b></td> </tr>\n";
	print "<tr $tb> <td><b>$text{'user_filesys_6'}</b></td>\n";
	print "<td><b>$text{'user_filesys_7'}</b></td> <td><b>$text{'user_filesys_8'}</b></td>\n";
	print "<td><b>$text{'user_filesys_9'}</b></td> <td><b>$text{'user_filesys_10'}</b></td>\n";
	print "<td><b>$text{'user_filesys_11'}</b></td> <td><b>$text{'user_filesys_12'}</b></td> </tr>\n";
	for($i=0; $i<$n; $i++) {
		$f = $filesys{$i,'filesys'};
		print "<tr $cb>\n";
		if ($fslist{$f}) {
			print "<td><a href=\"edit_user_quota.cgi?filesys=$f&user=$u&source=1\">$f</a></td>\n";
			}
		else { print "<td>$f</td>\n"; }
		print "<td>$filesys{$i,'ublocks'}</td>\n";
		&print_limit($filesys{$i,'sblocks'});
		&print_limit($filesys{$i,'hblocks'});
		print "<td>$filesys{$i,'ufiles'}</td>\n";
		&print_limit($filesys{$i,'sfiles'});
		&print_limit($filesys{$i,'hfiles'});
		print "</tr>\n";
		}
	print "</table><br>\n";
	}
else {
	print "<b>",&text('user_filesys_13', $u),"</b><p>\n";
	}

print "<table width=100%><tr>\n";
print "<form action=edit_user_quota.cgi>\n";
print "<input type=hidden name=user value=\"$u\">\n";
print "<input type=hidden name=source value=1>\n";
print "<td align=left><input type=submit value=\"$text{'user_filesys_15'}\">\n";
print "<select name=filesys>\n";
foreach $f (@fslist) { print "<option>$f\n"; }
print "</select></td></form>\n";

if ($access{'filesys'} eq "*") {
	print "<form action=copy_user_form.cgi>\n";
	print "<input type=hidden name=user value=\"$u\">\n";
	print "<td align=right><input type=submit value=\"$text{'user_filesys_16'}\">\n";
	print "</td></form>\n";
	}
print "</tr></table>\n";

print "<hr>\n";
&footer("", $text{'user_filesys_1'});

sub print_limit
{
if ($_[0] == 0) { print "<td>$text{'user_filesys_17'}</td>\n"; }
else { print "<td>$_[0]</td>\n"; }
}

