#!/usr/bin/perl
#
# postfix-module by Guillaume Cottenceau <gc@mandrakesoft.com>,
# for webmin by Jamie Cameron
#
# Copyright (c) 2000 by Mandrakesoft
#
# Permission to use, copy, modify, and distribute this software and its
# documentation under the terms of the GNU General Public License is hereby 
# granted. No representations are made about the suitability of this software 
# for any purpose. It is provided "as is" without express or implied warranty.
# See the GNU General Public License for more details.
#
#
# Save, modify, delete a map for Postfix


require './postfix-lib.pl';

&ReadParse();


#     &header($text{'aliases_title'}, "");

&error_setup($text{'map_save_err'});


my $maps = &get_maps($in{'map_name'});
my $add = 1; my %map;

foreach $trans (@{$maps})
{
    if ($trans->{'number'} == $in{'num'}) { $add = 0; %map = %{$trans}; }
}



my @maps_files = &get_maps_files(&get_current_value($in{'map_name'}));

defined($maps_files[0]) || &error($text{'mapps_no_map_file'});

if ($in{'delete'})
{
    if ($add == 1) { $whatfailed = ""; &error("Failed to delete map: ".$text{'map_delete_create'}); }
    my $all_maps = &read_file_lines($map{'map_file'});
    splice(@{$all_maps}, $map{'line'}, 1);
    &flush_file_lines();
}
elsif ($add == 0)
{
    # modify an existing map
    my $all_maps = &read_file_lines($map{'map_file'});
    $all_maps->[$map{'line'}] = "$in{'name'} $in{'value'}\n";
    &flush_file_lines();
}
else
{
    # add a new map -- much more easy! :-)
    open(MAPS, ">>$maps_files[0]") or &error($text{'maps_cant_write'});
    if ((print MAPS "$in{'name'} $in{'value'}\n") == 0) { &error($text{'maps_cant_write'}); }
    close(MAPS);
}
    


# re-creates aliases database

if ($in{'map_name'} =~ /canonical/) { &regenerate_canonical_table(); }
if ($in{'map_name'} =~ /relocated/) { &regenerate_relocated_table(); }
if ($in{'map_name'} =~ /virtual/) { &regenerate_virtual_table(); }

&reload_postfix();

&redirect("");




