#!/usr/local/bin/perl
# save_secret.cgi
# Update the secrets file to add or change a secret

require './pap-lib.pl';
&ReadParse();
$whatfailed = "Failed to save account";

if (defined($in{'idx'})) {
	@seclist = &list_secrets();
	%sec = %{$seclist[$in{'idx'}]};
	if ($in{'delete'}) {
		&delete_secret(%sec);
		&redirect("");
		exit;
		}
	}

if ($in{'client_def'}) { $sec{'client'} = ""; }
else { $sec{'client'} = $in{'client'}; }

if ($in{'server_def'}) { $sec{'server'} = "*"; }
else { $sec{'server'} = $in{'server'}; }

if ($in{'pass_mode'} == 0) { $sec{'secret'} = ""; }
elsif ($in{'pass_mode'} == 1) { $sec{'secret'} = "\@$in{'pass_file'}"; }
elsif ($in{'pass_mode'} == 3) { $sec{'secret'} = &opt_crypt($in{'pass_text'}); }

if ($in{'ips_mode'} == 0) { $sec{'ips'} = [ ]; }
elsif ($in{'ips_mode'} == 1) { $sec{'ips'} = [ "-" ]; }
elsif ($in{'ips_mode'} == 2) {
	@ips = split(/\s+/, $in{'ips'});
	foreach $ip (@ips) {
		if (!gethostbyname($ip)) {
			&error("'$ip' is not a valid address");
			}
		}
	$sec{'ips'} = \@ips;
	}

if (!defined($in{'idx'})) { &create_secret(\%sec); }
else { &change_secret(\%sec); }
&redirect("");

