# mysql-lib.pl
# Common MySQL functions

do '../web-lib.pl';
&init_config();
$ENV{$gconfig{'ld_env'}} .= ':'.$config{'mysql_libs'};
$authstr = &make_authstr();
$master_db = 'mysql';
%access = &get_module_acl();

@type_list = ('tinyint', 'smallint', 'mediumint', 'int', 'bigint',
	    'float', 'double', 'decimal', 'date', 'datetime', 'timestamp',
	    'time', 'year', 'char', 'varchar', 'tinyblob', 'tinytext',
	    'blob', 'text', 'mediumblob', 'mediumtext', 'longblob', 'longtext',
	    'enum', 'set');

sub make_authstr
{
return ($config{'login'} ? " -u $config{'login'}" : "").
       ($config{'pass'} ? " -p$config{'pass'}" : "");
}

# is_mysql_running()
# Returns 1 if mysql is running, 0 if not, or -1 if running but
# inaccessible without a password
sub is_mysql_running
{
local $out = `$config{'mysqladmin'} $authstr ping 2>&1`;
return $out =~ /alive/i ? 1 :
       $out =~ /denied/i ? -1 : 0;
}

# list_databases()
# Returns a list of all databases
sub list_databases
{
open(DBS, "$config{'mysqlshow'} $authstr |");
local $t = &parse_mysql_table(DBS);
close(DBS);
return map { $_->[0] } @{$t->{'data'}};
}

# list_tables(database)
# Returns a list of tables in some database
sub list_tables
{
if ($_[0] =~ /_/) {
	open(DBS, "$config{'mysqlshow'} $authstr $_[0] % |");
	}
else {
	open(DBS, "$config{'mysqlshow'} $authstr $_[0] |");
	}
local $t = &parse_mysql_table(DBS);
close(DBS);
return map { $_->[0] } @{$t->{'data'}};
}

# table_structure(database, table)
# Returns a list of hashes detailing the structure of a table
sub table_structure
{
local $s = &execute_sql($_[0], "desc $_[1]");
local (@rv, $r);
foreach $r (@{$s->{'data'}}) {
	push(@rv, { 'field' => $r->[0],
		    'type' => $r->[1],
		    'null' => $r->[2],
		    'key' => $r->[3],
		    'default' => $r->[4],
		    'extra' => $r->[5] });
	}
return @rv;
}

# execute_sql(database, command)
# Executes some SQL and returns the results
sub execute_sql
{
local $temp = &tempname();
open(TEMP, ">$temp");
print TEMP $_[1],"\n";
close(TEMP);
#open(DBS, "$config{'mysql'} $authstr -e \"$_[1]\" -t $_[0] 2>&1 |");
open(DBS, "$config{'mysql'} $authstr -t $_[0] <$temp 2>&1 |");
local $t = &parse_mysql_table(DBS);
close(DBS);
unlink($temp);
if ($t =~ /^ERROR.*:(.*)/) {
	&error(&text('esql', "<tt>$_[1]</tt>", "<tt>$1</tt>"));
	}
return $t;
}

# parse_mysql_table(handle)
# Given a filehandle, parses a text table in the format mysql uses
sub parse_mysql_table
{
local $fh = $_[0];
local $line;
do {
	# skip junk and first row of -'s
	$line = <$fh>;
	return $line if ($line =~ /^ERROR/);
	} while($line && $line !~ /^\|/);
local @titles = &parse_mysql_line($line);
$line = <$fh>;		# skip next row of -'s
local @data;
while(1) {
	$line = <$fh>;
	last if (!$line || $line !~ /^\|/);
	push(@data, [ &parse_mysql_line($line) ]);
	}
return { 'titles' => \@titles,
	 'data' => \@data };
}

sub parse_mysql_line
{
local @rv = split(/\|/, $_[0]);
shift(@rv); pop(@rv);
map { s/^\s+//; s/\s+$//; } @rv;
return @rv;
}

sub can_edit_db
{
local $d;
return 1 if ($access{'dbs'} eq '*');
foreach $d (split(/\s+/, $access{'dbs'})) {
	return 1 if ($d eq $_[0]);
	}
return 0;
}

1;

