#!/usr/local/bin/perl
# delete_list.cgi
# Delete a mailing list, after asking the user if he is sure

require './majordomo-lib.pl';
&ReadParse();
$name = $in{'name'};
%access = &get_module_acl();
&can_edit_list(\%access, $name) ||
	&error("You are not allowed to delete this mailing list");

# find aliases and files
$conf = &get_config();
$aliases_files = &get_aliases_file();
@aliases = &foreign_call("sendmail", "list_aliases", $aliases_files);
foreach $a (@aliases) {
	if ($a->{'name'} eq $name && $a->{'value'} =~ /-digestify/i) {
		&error("This list cannot be deleted as it appears ",
		       "to have an associated digest list");
		}
	if ($a->{'name'} =~ /-digestify$/i && $a->{'value'} =~ /\s$name\s/i) {
		$digestify = $a;
		}
	if ($a->{'name'} eq $name) {
		foreach $v (@{$a->{'values'}}) {
			$real_list = $1
				if ($v =~ /^\|\S*wrapper\s+resend.*\s(\S+)$/);
			}
		}
	}
@daliases = grep { $_->{'name'} =~ /^$name$/i ||
		  $_->{'name'} eq $real_list ||
		  $_->{'name'} =~ /^$name-(list|owner|approval|outgoing|request)$/i ||
		  $_->{'name'} =~ /owner-$name-outgoing$/i ||
		  $_->{'name'} =~ /$name-outgoing-(list|owner|approval)$/i ||
		  $_ eq $digestify ||
		  $_->{'name'} =~ /^owner-$name$/i } @aliases;
$ldir = &perl_var_replace(&find_value("listdir", $conf), $conf);
opendir(LDIR, $ldir);
while($f = readdir(LDIR)) {
	if ($f eq $name || $f =~ /^$name\./) {
		push(@files, "$ldir/$f");
		}
	}
closedir(LDIR);

if ($in{'confirm'}) {
	# do the deletion
	unlink(@files);
	@daliases = sort { $b->{'line'} <=> $a->{'line'} } @daliases;
	foreach $a (@daliases) {
		&foreign_call("sendmail", "delete_alias", $a, $aliases_file);
		}

	if ($digestify) {
		# delete the digestify alias from the 'parent' list
		foreach $a (@aliases) {
			$idx = &indexof($digestify->{'name'},@{$a->{'values'}});
			if ($idx >= 0) {
				splice(@{$a->{'values'}}, $idx, 1);
				&foreign_call("sendmail",
					      "modify_alias", $a, $a);
				}
			}
		}

	# remove from ACLs
	&read_acl(undef, \%wusers);
	foreach $u (keys %wusers) {
		%uaccess = &get_module_acl($u);
		$uaccess{'lists'} = join(' ', grep { $_ ne $name }
					      split(/\s+/, $uaccess{'lists'}));
		&save_module_acl(\%uaccess, $u) if ($uaccess{'lists'} ne '*');
		}
	&redirect("");
	}
else {
	# ask the user if he is sure
	&header("Delete List", "");
	print "<hr>\n";
	print "<form action=delete_list.cgi>\n";
	print "<input type=hidden name=name value=\"$name\">\n";
	print "<input type=hidden name=confirm value=1>\n";
	print "<b>Are you sure you want to delete the mailing list\n";
	print "<tt>$name</tt>? The following files will be deleted :</b><br>\n";
	print "<ul>\n";
	foreach $f (@files) {
		print "<tt>$f</tt><br>\n";
		}
	print "</ul>\n";
	print "<b>The following mail aliases will also be deleted :</b><br>\n";
	print "<ul>\n";
	foreach $a (@daliases) {
		print "<tt>$a->{'name'}: $a->{'value'}</tt><br>\n";
		}
	print "</ul>\n";
	print "<center><input type=submit value='Delete List'></center>\n";
	print "</form>\n";
	print "<hr>\n";
	&footer("edit_list.cgi?name=$name", "mailing list");
	}

