#!/usr/local/bin/perl
# save_export.cgi
# Save changes to a exported directory

require './hpuxexports-lib.pl';
$whatfailed = "Failed to save export";
use Socket;
&ReadParse();

# check inputs
if ($in{directory} !~ /^\/.*/) {
	&error("$in{directory} is not a valid directory name");
	}
if (!(-d $in{directory})) {
	&error("The directory $in{directory} does not exist");
	}
@ualist = split(/\s+/, $in{ualist}); &check_hosts(@ualist);
@rtlist = split(/\s+/, $in{rtlist}); &check_hosts(@rtlist);
if (($in{user} == 1 || $in{user} == 3 || $in{user} == 4) && !@ualist) {
	&error("You did not list any hosts to export read-write with");
	}
if ($in{root} == 2 && !@rtlist) {
	&error("You did not list any hosts to export root with");
	}

# Remove from the root list any hosts which not in the user list as well
if (($in{user} == 1 || $in{user} == 3 || $in{user} == 4) && $in{root} == 2) {
	@tmplist = @rtlist;
	foreach $rth (@tmplist) {
		if (($idx = &indexof($rth, @ualist)) == -1) {
			splice(@rtlist, &indexof($rth, @rtlist), 1);
			}
		}
	if (@rtlist == 0) {
		$in{root} = 1;
		}
	}

if ($in{old}) {
	# Changing an existing export 
	if ($in{old} ne $in{directory} && &get_exports($in{directory})) {
		&error("The directory $in{directory} is already being exported");
		}
	@oinfo = &get_exports($in{old});	# keep unknown options
	&parse_options($oinfo[3]);
	&set_options();
	&modify_export($in{old}, $in{directory}, &join_options());
	}
else {
	# Creating a new export 
	if (&get_exports($in{directory})) {
		&error("The directory $in{directory} is already being exported");
		}
	&set_options();
	&create_export($in{directory}, &join_options());
	}
&redirect("");


# set_options()
# Fill in the options associative array
sub set_options
{
delete($options{"ro"});
delete($options{"rw"});
delete($options{"access"});
if ($in{user} == 1) { $options{"ro"}; $options{"access"} = join(':', @ualist); }
elsif ($in{user} == 2) { $options{"ro"} = ""; }
elsif ($in{user} == 3) { $options{"rw"} = join(':', @ualist); }
elsif ($in{user} == 4) { $options{"access"} = join(':', @ualist); }
elsif ($in{user} == 5) { ; }

if ($in{root} == 1) { delete($options{"root"}); }
elsif ($in{root} == 2) { $options{"root"} = join(':', @rtlist); }

if ($in{async} == 1) { $options{"async"} = ""; }
else { delete($options{"async"}); }

if ($in{anon} eq "") { delete($options{"anon"}); }
else { $options{"anon"} = $in{anon}; }
}

# check_hosts(host, host, ...)
# Die if any of the listed hosts does not exist
sub check_hosts
{
foreach (@_) {
	if (!inet_aton($_)) { &error("The host $_ does not exist"); }
	}
}


