# export-lib.pl
# Common functions for the linux exports file

do '../web-lib.pl';
&init_config();

# list_exports()
# Returns a list of all exports
sub list_exports
{
local (@rv, $pos, $lnum, $h, $o);
return @list_exports_cache if (@list_exports_cache);
open(EXP, $config{'exports_file'});
$lnum = 0;
while(<EXP>) {
	s/\s+$//g;
	if (/^(#*)\s*(\/\S*)\s+(.*)$/) {
		local $active = !$1;
		local $dir = $2;
		local $rest = $3;
		$pos = 0;
		while($rest =~ /^([^\s+\(\)]*)\(([^\)]*)\)\s*(.*)$/ ||
		      $rest =~ /^([^\s+\(\)]+)\s*()(.*)$/) {
			local %exp;
			$exp{'active'} = $active;
			$exp{'dir'} = $dir;
			$exp{'host'} = $1;
			local $ostr = $2;
			$rest = $3;
			while($ostr =~ /^([a-z_]+)=([0-9,\-]+)\s*,\s*(.*)$/ ||
			      $ostr =~ /^([a-z_]+)=([0-9,\-]+)(.*)$/ ||
			      $ostr =~ /^([a-z_]+)=([^,\s]+),(.*)$/ ||
			      $ostr =~ /^([a-z_]+)=([^,\s]+)(.*)$/ ||
			      $ostr =~ /^([a-z_]+)()\s*,\s*(.*)$/ ||
			      $ostr =~ /^([a-z_]+)()(.*)$/) {
				if ($2 ne "") { $exp{'options'}->{$1} = $2; }
				else { $exp{'options'}->{$1} = ""; }
				$ostr = $3;
				}
			$exp{'line'} = $lnum;
			$exp{'pos'} = $pos++;
			$exp{'index'} = scalar(@rv);
			push(@rv, \%exp);
			}
		}
	$lnum++;
	}
close(EXP);
@list_exports_cache = @rv;
return @list_exports_cache;
}

# delete_export(&export)
# Delete an existing export
sub delete_export
{
local @exps = &list_exports();
local @same = grep { $_ ne $_[0] && $_->{'line'} eq $_[0]->{'line'} } @exps;
if (@same) {
	# other exports on the same line.. cannot totally delete
	&replace_file_line($config{'exports_file'}, $_[0]->{'line'},
			   &make_exports_line(@same));
	}
else {
	# remove export line
	&replace_file_line($config{'exports_file'}, $_[0]->{'line'});
	}
}

# create_export(&export)
sub create_export
{
open(EXP, ">>$config{'exports_file'}");
print EXP &make_exports_line($_[0]);
close(EXP);
}

# modify_export(&export, &old)
sub modify_export
{
local @exps = &list_exports();
local @same = grep { $_->{'line'} eq $_[1]->{'line'} } @exps;
if ($_[0]->{'dir'} eq $_[1]->{'dir'} &&
    $_[0]->{'active'} == $_[1]->{'active'} || @same == 1) {
	# directory not changed, or on a line of it's own
	splice(@same, &indexof($_[1],@same), 1, $_[0]);
	&replace_file_line($config{'exports_file'}, $_[1]->{'line'},
			   &make_exports_line(@same));
	}
else {
	# move to a line of it's own
	splice(@same, &indexof($_[1],@same), 1);
	&replace_file_line($config{'exports_file'}, $_[1]->{'line'},
			   &make_exports_line(@same));
	open(EXP, ">>$config{'exports_file'}");
	print EXP &make_exports_line($_[0]);
	close(EXP);
	}
}

# make_exports_line([&export]+)
sub make_exports_line
{
local ($e, @htxt);
foreach $e (@_) {
	local %opts = %{$e->{'options'}};
	if (%opts || !$e->{'host'}) {
		push(@htxt, $e->{'host'}."(".
			    join(",", map { $opts{$_} eq "" ? $_
							    : "$_=$opts{$_}" }
			    (keys %opts)).")");
		}
	else { push(@htxt, $e->{'host'}); }
	}
return ($_[0]->{'active'} ? "" : "#").
       $_[0]->{'dir'}."\t".join(" ", @htxt)."\n";
}

# describe_host(host)
# Given a host, regexp or netgroup return a human-readable version
sub describe_host
{
if ($_[0] eq "=public") { return "WebNFS&nbsp;clients"; }
elsif ($_[0] =~ /^\@(.*)/) { return "Netgroup&nbsp;<i>$1</i>"; }
elsif ($_[0] =~ /^(\S+)\/(\S+)$/) {
	return "Network&nbsp;<i>$1/$2</i>"; }
elsif ($_[0] eq "" || $_[0] eq "*") { return "Everyone"; }
elsif ($_[0] =~ /\*/) { return "Hosts&nbsp;<i>$_[0]</i>"; }
else { return "Host&nbsp;<i>$_[0]</i>"; }
}

1;

