#!/usr/local/bin/perl
# exec_cron.cgi
# Execute an existing cron job, and display the output

require './cron-lib.pl';
&foreign_require("proc", "proc-lib.pl");
&ReadParse();

%access = &get_module_acl();
@jobs = &list_cron_jobs();
$job = $jobs[$in{'idx'}];
&can_edit_user(\%access, $job->{'user'}) || &error($text{'exec_ecannot'});

$| = 1;
&header($text{'exec_title'}, "");
print "<hr>\n";

# Get command and switch uid/gid
@uinfo = getpwnam($job->{'user'});
$ENV{"HOME"} = $uinfo[7];
$ENV{"SHELL"} = "/bin/sh";
$ENV{"LOGNAME"} = $ENV{"USER"} = $job->{'user'};
$( = $) = $uinfo[3];
$< = $> = $uinfo[2];

# Create temp file with inputs
$job->{'command'} =~ s/\\%/\0/g;
@lines = split(/%/ , $job->{'command'});
foreach (@lines) { s/\0/%/g; }
for($i=1; $i<@lines; $i++) {
	$input .= $lines[$i]."\n";
	}

# Execute cron command and display output..
print &text('exec_cmd', "<tt>$lines[0]</tt>"),"<p>\n";
print "<pre>";
$got = &foreign_call("proc", "safe_process_exec", $lines[0], 0, 0, STDOUT, $input, 1);
print "<i>$text{'exec_none'}</i>\n" if (!$got);
print "</pre>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

