#!/usr/local/bin/perl
# start.cgi
# Start bind 8

require './bind8-lib.pl';
%access = &get_module_acl();
$access{'ro'} && &error($text{'start_ecannot'});
$access{'apply'} || &error($text{'start_ecannot'});
if ($config{'start_cmd'}) {
	$cmd = $config{'start_cmd'};
	}
elsif (!$config{'chroot'}) {
	$cmd = "$config{'named_path'} -c $config{'named_conf'} </dev/null 2>&1";
	}
elsif (`$config{'named_path'} -help 2>&1` =~ /\[-t/) {
	# use named's chroot option
	$cmd = "$config{'named_path'} -c $config{'named_conf'} -t $config{'chroot'} </dev/null 2>&1";
	}
else {
	# use the chroot command
	$cmd = "chroot $config{'chroot'} $config{'named_path'} -c $config{'named_conf'} </dev/null 2>&1";
	}

$temp = &tempname();
$rv = system("$cmd </dev/null >$temp 2>&1");
$out = `cat $temp`;
unlink($temp);
if ($rv || $out =~ /chroot.*not available/i) {
	&error(&text('start_error', "<tt>$out</tt>"));
	}
&redirect("");

