# mod_proxy.pl
# Editors for proxy directives

sub mod_proxy_directives
{
$rv = [ [ 'ProxyRequests', 0, 13, 'virtual', undef, 11 ],
        [ 'ProxyRemote', 1, 13, 'virtual', undef, 7 ],
        [ 'ProxyPass', 1, 10, 'virtual', undef, 0 ],
        [ 'ProxyPassReverse', 1, 10, 'virtual', 1.306, 0 ],
        [ 'ProxyBlock', 1, 13, 'virtual', 1.2, 9 ],
        [ 'NoProxy', 1, 13, 'virtual', 1.3, 5 ],
        [ 'ProxyDomain', 0, 13, 'virtual', 1.3, 4 ],
	[ 'AllowCONNECT', 0, 13, 'virtual', 1.302, 2 ],
        [ 'CacheRoot', 0, 13, 'virtual', undef, 10 ],
        [ 'CacheSize', 0, 13, 'virtual' ],
        [ 'CacheGcInterval', 0, 13, 'virtual' ],
        [ 'CacheMaxExpire', 0, 13, 'virtual' ],
        [ 'CacheLastModifiedFactor', 0, 13, 'virtual' ],
        [ 'CacheDirLevels', 0, 13, 'virtual' ],
        [ 'CacheDirLength', 0, 13, 'virtual' ],
        [ 'CacheDefaultExpire', 0, 13, 'virtual' ],
        [ 'CacheForceCompletion', 0, 13, 'virtual', 1.301 ],
        [ 'NoCache', 1, 13, 'virtual', undef, 3 ] ];
return &make_directives($rv, $_[0], "mod_proxy");
}

sub edit_ProxyRequests
{
return (1, "$text{'mod_proxy_0'}", 
        &choice_input($_[0]->{'value'}, "ProxyRequests", "off",
                      "$text{'mod_proxy_1'},on", "$text{'mod_proxy_2'},off"));
}
sub save_ProxyRequests
{
return &parse_choice("ProxyRequests", "off");
}

sub edit_ProxyRemote
{
local($rv, $i, $match, $proxy, $max);
$rv = "<table border>\n".
      "<tr $tb> <td><b>$text{'mod_proxy_3'}</b></td> <td><b>$text{'mod_proxy_4'}</b></td> </tr>\n";
$max = @{$_[0]}+1;
for($i=0; $i<$max; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(\S+)$/) {
		$match = $1; $proxy = $2;
		}
	else { $match = "*"; $proxy = ""; }
	$rv .= "<tr $cb>\n";
	$rv .= sprintf
	        "<td><input type=radio name=ProxyRemote_match_all_$i %s> $text{'mod_proxy_5'}\n",
	        $match eq "*" ? "checked" : "";
	$rv .= sprintf
	        "<input type=radio name=ProxyRemote_match_all_$i %s> $text{'mod_proxy_6'}\n",
	        $match eq "*" ? "" : "checked";
	$rv .= sprintf
	        "<input name=ProxyRemote_match_$i size=30 value=\"%s\"></td>\n",
	        $match eq "*" ? "" : $match;
	$rv .= "<td><input name=ProxyRemote_proxy_$i size=30 ".
	       "value=\"$proxy\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "$text{'mod_proxy_7'}", $rv);
}
sub save_ProxyRemote
{
local($i, $match, $match_all, $proxy, @rv);
for($i=0; defined($proxy = $in{"ProxyRemote_proxy_$i"}); $i++) {
	$match = $in{"ProxyRemote_match_$i"};
	$match_all = $in{"ProxyRemote_match_all_$i"};
	if ($match !~ /\S/ && $proxy !~ /\S/) { next; }
	if ($match_all) { $match = "*"; }
	elsif ($match !~ /^\S+$/) { &error(&text('mod_proxy_54', $match)); }
	$proxy =~ /^http:\/\/\S+$/ || &error(&text('mod_proxy_55', $proxy));
	push(@rv, "$match $proxy");
	}
return ( \@rv );
}

sub edit_ProxyPass
{
local($rv, $i, $path, $url, $max);
$rv = "<table border>\n".
      "<tr $tb> <td><b>$text{'mod_proxy_8'}</b></td> <td><b>$text{'mod_proxy_9'}</b></td> </tr>\n";
$max = @{$_[0]} + 1;
for($i=0; $i<$max; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(\S+)$/) {
		$path = $1; $url = $2;
		}
	else { $path = $url = ""; }
	$rv .= "<tr $cb>\n";
	$rv .= "<td><input name=ProxyPass_path_$i size=20 value=\"$path\"></td>\n";
	$rv .= "<td><input name=ProxyPass_url_$i size=30 value=\"$url\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "$text{'mod_proxy_10'}", $rv);
}
sub save_ProxyPass
{
local($i, $url, $path, @rv);
for($i=0; defined($path = $in{"ProxyPass_path_$i"}); $i++) {
	$url = $in{"ProxyPass_url_$i"};
	if ($path !~ /\S/ && $url !~ /\S/) { next; }
	$path =~ /^\/\S*$/ || &error(&text('mod_proxy_56', $path));
	$url =~ /^http:\/\/(\S+)$/ || &error(&text('mod_proxy_57', $url));
	push(@rv, "$path $url");
	}
return ( \@rv );
}

sub edit_ProxyPassReverse
{
local($rv, $i, $path, $url, $max);
$rv = "<table border>\n".
      "<tr $tb> <td><b>$text{'mod_proxy_64'}</b></td> <td><b>$text{'mod_proxy_65'}</b></td> </tr>\n";
$max = @{$_[0]} + 1;
for($i=0; $i<$max; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(\S+)$/) {
		$path = $1; $url = $2;
		}
	else { $path = $url = ""; }
	$rv .= "<tr $cb>\n";
	$rv .= "<td><input name=ProxyPassReverse_url_$i size=30 value=\"$url\"></td>\n";
	$rv .= "<td><input name=ProxyPassReverse_path_$i size=20 value=\"$path\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "$text{'mod_proxy_66'}", $rv);
}
sub save_ProxyPassReverse
{
local($i, $url, $path, @rv);
for($i=0; defined($path = $in{"ProxyPassReverse_path_$i"}); $i++) {
	$url = $in{"ProxyPassReverse_url_$i"};
	if ($path !~ /\S/ && $url !~ /\S/) { next; }
	$path =~ /^\/\S*$/ || &error(&text('mod_proxy_56', $path));
	$url =~ /^http:\/\/(\S+)$/ || &error(&text('mod_proxy_57', $url));
	push(@rv, "$path $url");
	}
return ( \@rv );
}

sub edit_ProxyBlock
{
local($b, @b);
foreach $b (@{$_[0]}) { push(@b, split(/\s+/, $b->{'value'})); }
return (2, "$text{'mod_proxy_11'}",
        &opt_input(@b ? join(' ', @b) : undef, "ProxyBlock", "None", 50));
}
sub save_ProxyBlock
{
return &parse_opt("ProxyBlock", '\S', "$text{'mod_proxy_12'}");
}

sub edit_NoProxy
{
local($n, @n, $i, $rv);
foreach $n (@{$_[0]}) { push(@n, split(/\s+/, $n->{'value'})); }
$rv = "<table border>\n".
      "<tr $tb> <td><b>$text{'mod_proxy_13'}</b></td> <td><b>$text{'mod_proxy_14'}</b></td> </tr>\n";
for($i=0; $i<=@n; $i++) {
	$rv .= "<tr $cb>\n";
	if ($i>=@n) { $type = 0; }
	elsif ($n[$i] =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
		if ($4 == 0) { $type = 3; }
		else { $type = 0; }
		}
	elsif ($n[$i] =~ /^([0-9\.]+)\/(\d+)$/) { $type = 4; }
	elsif ($n[$i] =~ /^([0-9\.]+)$/) { $type = 3; }
	elsif ($n[$i] =~ /^\.(\S+)$/) { $type = 2; }
	else { $type = 1; }
	$rv .= "<td>".&select_input($type, "NoProxy_type_$i", 0, "IP address,0",
	        "Hostname,1", "Domain,2", "IP network,3", "Network/bits,4")."</td>\n";
	$rv .= "<td><input name=NoProxy_for_$i size=30 value=\"$n[$i]\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "$text{'mod_proxy_15'}", $rv);
}
sub save_NoProxy
{
local($i, $type, $for, @rv);
for($i=0; defined($type = $in{"NoProxy_type_$i"}); $i++) {
	$for = $in{"NoProxy_for_$i"};
	if ($for !~ /\S/) { next; }
	if ($type == 0) {
		&check_ipaddress($for) || 
			&error(&text('mod_proxy_58', $for));
		}
	elsif ($type == 1) {
		$for =~ /^[A-z0-9\-][A-z0-9\-\.]+[A-z0-9\-]$/ ||
			&error(&text('mod_proxy_59', $for));
		}
	elsif ($type == 2) {
		$for =~ /^\.[A-z0-9\-\.]+[A-z0-9\-]$/ ||
			&error(&text('mod_proxy_60', $for));
		}
	elsif ($type == 3) {
		if ($for =~ /^(\d+)$/) { $for .= ".0.0.0"; }
		elsif ($for =~ /^(\d+)\.(\d+)$/) { $for .= ".0.0"; }
		elsif ($for =~ /^(\d+)\.(\d+)\.(\d+)$/) { $for .= ".0"; }
		&check_ipaddress($for) || &error(&text('mod_proxy_61', $for));
		}
	elsif ($type == 4) {
		($for =~ /^(\S+)\/(\d+)$/ && &check_ipaddress($1) && $2 < 32) ||
			&error(&text('mod_proxy_62', $for));
		}
	push(@rv, $for);
	}
return @rv ? ( [ join(' ', @rv) ] ) : ( [ ] );
}

sub edit_ProxyDomain
{
return (1, "$text{'mod_proxy_16'}",
        &opt_input($_[0]->{'value'}, "ProxyDomain", "$text{'mod_proxy_17'}", 20));
}
sub save_ProxyDomain
{
return &parse_opt("ProxyDomain", '^[A-z0-9\-]+$', "$text{'mod_proxy_18'}");
}

sub edit_AllowCONNECT
{
return (1, "$text{'mod_proxy_19'}",
        &opt_input($_[0]->{'value'}, "AllowCONNECT", "$text{'mod_proxy_20'}", 10));
}
sub save_AllowCONNECT
{
return &parse_opt("AllowCONNECT", '^[\d ]+$', "$text{'mod_proxy_21'}");
}

sub edit_CacheRoot
{
return (1, "$text{'mod_proxy_22'}",
        &opt_input($_[0]->{'value'}, "CacheRoot", "$text{'mod_proxy_23'}", 20).
        &file_chooser_button("CacheRoot", 0));
}
sub save_CacheRoot
{
$in{'CacheRoot_def'} || &allowed_auth_file($in{'CacheRoot'}) ||
	&error($text{'mod_proxy_63'});
return &parse_opt("CacheRoot", '^\S+$', "$text{'mod_proxy_24'}");
}

sub edit_CacheSize
{
return (1, "$text{'mod_proxy_25'}",
        &opt_input($_[0]->{'value'}, "CacheSize", "$text{'mod_proxy_26'}", 8)." Kb");
}
sub save_CacheSize
{
return &parse_opt("CacheSize", '^\d+$', "$text{'mod_proxy_27'}");
}

sub edit_CacheGcInterval
{
return (1, "$text{'mod_proxy_28'}",
        &opt_input($_[0]->{'value'}, "CacheGcInterval", "$text{'mod_proxy_29'}", 6)." $text{'mod_proxy_30'}");
}
sub save_CacheGcInterval
{
return &parse_opt("CacheGcInterval", '^\d+$',
                  "$text{'mod_proxy_31'}");
}

sub edit_CacheMaxExpire
{
return (1, "$text{'mod_proxy_32'}",
        &opt_input($_[0]->{'value'}, "CacheMaxExpire", "$text{'mod_proxy_33'}", 6)." $text{'mod_proxy_34'}");
}
sub save_CacheMaxExpire
{
return &parse_opt("CacheMaxExpire", '^\d+$',
                  "$text{'mod_proxy_35'}");
}

sub edit_CacheLastModifiedFactor
{
return (1, "$text{'mod_proxy_36'}",
        &opt_input($_[0]->{'value'}, "CacheLastModifiedFactor", "$text{'mod_proxy_37'}", 6));
}
sub save_CacheLastModifiedFactor
{
return &parse_opt("CacheLastModifiedFactor", '^\d+$',
                  "$text{'mod_proxy_38'}");
}

sub edit_CacheDirLevels
{
return (1, "$text{'mod_proxy_39'}",
        &opt_input($_[0]->{'value'}, "CacheDirLevels", "$text{'mod_proxy_40'}", 6));
}
sub save_CacheDirLevels
{
return &parse_opt("CacheDirLevels", '^\d+$',
                  "$text{'mod_proxy_41'}");
}

sub edit_CacheDirLength
{
return (1, "$text{'mod_proxy_42'}",
        &opt_input($_[0]->{'value'}, "CacheDirLength", "$text{'mod_proxy_43'}", 4));
}
sub save_CacheDirLength
{
return &parse_opt("CacheDirLength", '^\d+$',
                  "$text{'mod_proxy_44'}");
}

sub edit_CacheDefaultExpire
{
return (1, "$text{'mod_proxy_45'}",
        &opt_input($_[0]->{'value'}, "CacheDefaultExpire", "$text{'mod_proxy_46'}", 6).
	" hours");
}
sub save_CacheDefaultExpire
{
return &parse_opt("CacheDefaultExpire", '^\d+$', "$text{'mod_proxy_47'}");
}

sub edit_CacheForceCompletion
{
return (1, "$text{'mod_proxy_48'}",
        &opt_input($_[0]->{'value'}, "CacheForceCompletion", "$text{'mod_proxy_49'}", 6)."%");
}
sub save_CacheForceCompletion
{
return &parse_opt("CacheForceCompletion", '^\d+$',
		  "$text{'mod_proxy_50'}");
}

sub edit_NoCache
{
local($n, @n);
foreach $n (@{$_[0]}) { push(@n, $n->{'value'}); }
return (1, "$text{'mod_proxy_51'}",
        &opt_input(@n ? join(' ', @n) : undef, "NoCache", "$text{'mod_proxy_52'}", 20));
}
sub save_NoCache
{
return &parse_opt("NoCache", '\S', "$text{'mod_proxy_53'}");
}

1;

