#!/usr/local/bin/perl
# delete_user.cgi
# Delete a user, after asking for confirmation

require './user-lib.pl';
&ReadParse();
@ulist = &list_users();
%user = %{$ulist[$in{'num'}]};
&error_setup($text{'udel_err'});
%access = &get_module_acl();
&can_edit_user(\%access, \%user) || &error($text{'udel_euser'});

$| = 1;
&header($text{'udel_title'}, "");
print "<hr>\n";
if ($in{'confirmed'}) {
	# Check for repeat click
	if ($user{'user'} ne $in{'user'}) {
		print "<b>$text{'udel_ealready'}</b>. <p>\n";
		print "<hr>\n";
		&footer("", $text{'index_return'});
		exit;
		}

	# Go ahead and do it!
	print "$text{'udel_other'}<br>\n";
	&other_modules("useradmin_delete_user", \%user);
	print "$text{'udel_done'}<p>\n";
	
	print "$text{'udel_pass'}<br>\n";
	$ENV{'USERADMIN_USER'} = $user{'user'};
	$ENV{'USERADMIN_ACTION'} = 'DELETE_USER';
	&making_changes();
	&delete_user(\%user);
	print "$text{'udel_done'}<p>\n";

	print "$text{'udel_groups'}<br>\n";
	foreach $g (&list_groups()) {
		@mems = split(/,/, $g->{'members'});
		$idx = &indexof($user{'user'}, @mems);
		if ($idx >= 0) {
			splice(@mems, $idx, 1);
			%newg = %$g;
			$newg{'members'} = join(',', @mems);
			&modify_group($g, \%newg);
			}
		$mygroup = $g if ($g->{'group'} eq $user{'user'});
		}
	print "$text{'udel_done'}<p>\n";

	if ($config{'new_user_group'} && $mygroup && !$mygroup->{'members'}) {
		local $another;
		foreach $ou (&list_users()) {
			$another++ if ($ou->{'gid'} == $mygroup->{'gid'});
			}
		if (!$another) {
			print "$text{'udel_ugroup'}<br>\n";
			&delete_group($mygroup);
			print "$text{'udel_done'}<p>\n";
			}
		}
	&made_changes();

	if ($in{'delhome'} && $user{'home'} !~ /^\/+$/) {
		print "$text{'udel_home'}<br>\n";
		`rm -rf "$user{'home'}"`;
		print "$text{'udel_done'}<p>\n";
		}

	print "<hr>\n";
	&footer("", $text{'index_return'});
	}
else {
	# Check if something has changed
	if ($user{'user'} ne $in{'user'}) {
		print "<b>$text{'udel_echanged'}</b> <p>\n";
		print "<hr>\n";
		&footer("", $text{'index_return'});
		exit;
		}

	# Ask if the user is sure
	print "<form action=delete_user.cgi>\n";
	print "<input type=hidden name=num value=\"$in{'num'}\">\n";
	print "<input type=hidden name=user value=\"$user{'user'}\">\n";
	print "<input type=hidden name=confirmed value=1>\n";

	if ($user{'home'} ne "/") {
		`du -sk $user{'home'}` =~ /^([0-9]+)/; $size = $1;
		print "<center><h3>",&text('udel_sure', $user{'user'},
					   $user{'home'}, $size),"</h3>\n";
		print "<input type=submit value=\"$text{'udel_del1'}\">\n";
		print "<input name=delhome type=submit ",
		      "value=\"$text{'udel_del2'}\">\n";
		}
	else {
		print "<center><h3>",&text('udel_sure2',
					   $user{'user'}),"</h3>\n";
		print "<input type=submit value=\"$text{'udel_del1'}\">\n";
		}
	print "</form></center>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	}

