#!/usr/local/bin/perl
# link.cgi
# Forward the URL from path_info on to another webmin server

require './servers-lib.pl';
$ENV{'PATH_INFO'} =~ /^\/(\d+)(.*)$/ ||
	&error("Bad PATH_INFO : $ENV{'PATH_INFO'}");
$path = $2 ? $2 : '/';
if ($ENV{'QUERY_STRING'}) {
	$path .= '?'.$ENV{'QUERY_STRING'};
	}
elsif (@ARGV) {
	$path .= '?'.join('+', @ARGV);
	}
$s = &get_server($1);
$url = "/$module_name/link.cgi/$s->{'id'}";
$| = 1;
$meth = $ENV{'REQUEST_METHOD'};

if ($s->{'ssl'}) {
	# connect using SSL (maybe through a proxy)
	eval "use Net::SSLeay";
	$@ && &error("You do not have the perl Net::SSLeay library installed");
	eval "Net::SSLeay::SSLeay_add_ssl_algorithms()";
	eval "Net::SSLeay::load_error_strings()";
	$ssl_ctx = Net::SSLeay::CTX_new() ||
		&error("Failed to create SSL context");
	$ssl_con = Net::SSLeay::new($ssl_ctx) ||
		&error("Failed to create SSL connection");
	if ($gconfig{'http_proxy'} =~ /^http:\/\/(\S+):(\d+)/ &&
	    !&no_proxy($s->{'host'})) {
		&open_socket($1, $2, SOCK);
		print SOCK "CONNECT $s->{'host'}:$s->{'port'} HTTP/1.0\r\n";
		print SOCK "\r\n";
		}
	else {
		&open_socket($s->{'host'}, $s->{'port'}, SOCK);
		}
	Net::SSLeay::set_fd($ssl_con, fileno(SOCK));
	Net::SSLeay::connect($ssl_con) || &error("SSL connect() failed");
	&write_sock_line("$meth $path HTTP/1.0\r\n");
	}
else {
	# connect to the remote server (maybe through a proxy)
	if ($gconfig{'http_proxy'} =~ /^http:\/\/(\S+):(\d+)/ &&
	    !&no_proxy($s->{'host'})) {
		&open_socket($1, $2, SOCK);
		&write_sock_line("$meth http://$s->{'host'}:$s->{'port'}$path ".
				 "HTTP/1.0\r\n");
		}
	else {
		&open_socket($s->{'host'}, $s->{'port'}, SOCK);
		&write_sock_line("$meth $path HTTP/1.0\r\n");
		}
	}

# Send request headers
&write_sock_line("Host: $s->{'host'}\r\n");
&write_sock_line("User-agent: Webmin\r\n");
$auth = &encode_base64("$s->{'user'}:$s->{'pass'}");
$auth =~ s/\n//g;
&write_sock_line("Authorization: basic $auth\r\n");
&write_sock_line(sprintf "Webmin-servers: %s://%s:%d/$module_name/\n",
			 $ENV{'HTTPS'} eq "ON" ? "https" : "http",
			 $ENV{'SERVER_NAME'}, $ENV{'SERVER_PORT'});
$cl = $ENV{'CONTENT_LENGTH'};
&write_sock_line("Content-length: $cl\r\n") if ($cl);
&write_sock_line("Content-type: $ENV{'CONTENT_TYPE'}\r\n")
	if ($ENV{'CONTENT_TYPE'});
&write_sock_line("\r\n");
if ($cl) {
	read(STDIN, $post, $cl);
	&write_sock_line($post);
	}

# read back the headers
$dummy = &read_sock_line();
while(1) {
	($headline = &read_sock_line()) =~ s/\r|\n//g;
	last if (!$headline);
	$headline =~ /^(\S+):\s+(.*)$/ || &error("Bad header");
	$header{lc($1)} = $2;
	$headers .= $headline."\n";
	}

if ($header{'location'} =~ /^(http|https):\/\/$s->{'host'}:$s->{'port'}(.*)$/) {
	# fix a redirect
	&redirect("$url$2");
	exit;
	}
else {
	# just output the headers
	print $headers,"\n";
	}

# read back the rest of the page
if ($header{'content-type'} eq 'text/html') {
	while($_ = &read_sock_line()) {
		s/src='(\/[^"]*)'/src="$url$1"/gi;
		s/src="(\/[^"]*)"/src="$url$1"/gi;
		s/src=(\/[^ >]*)/src=$url$1/gi;
		s/href='(\/[^"]*)'/href="$url$1"/gi;
		s/href="(\/[^"]*)"/href="$url$1"/gi;
		s/href=(\/[^ >]*)/href=$url$1/gi;
		s/action='(\/[^"]*)'/action="$url$1"/gi;
		s/action="(\/[^"]*)"/action="$url$1"/gi;
		s/action=(\/[^ >]*)/action=$url$1/gi;
		print;
		}
	}
else {
	while($buf = &read_sock_data(1024)) {
		print $buf;
		}
	}
close(SOCK);

sub write_sock_line
{
if ($ssl_con) {
	foreach (@_) {
		Net::SSLeay::write($ssl_con, $_);
		}
	}
else {
	print SOCK @_;
	}
}

sub read_sock_line
{
local($idx, $more, $rv);
if ($ssl_con) {
	while(($idx = index($read_buffer, "\n")) < 0) {
		# need to read more..
		if (!($more = Net::SSLeay::read($ssl_con))) {
			# end of the data
			$rv = $read_buffer;
			undef($read_buffer);
			return $rv;
			}
		$read_buffer .= $more;
		}
	$rv = substr($read_buffer, 0, $idx+1);
	$read_buffer = substr($read_buffer, $idx+1);
	return $rv;
	}
else { return <SOCK>; }
}

sub read_sock_data
{
if ($ssl_con) {
	local($rv);
	if (length($read_buffer)) {
		$rv = $read_buffer;
		undef($read_buffer);
		return $rv;
		}
	else {
		return Net::SSLeay::read($ssl_con, $_[0]);
		}
	}
else {
	local($buf);
	read(SOCK, $buf, $_[0]) || return undef;
	return $buf;
	}
}

