#!/usr/local/bin/perl
# Display a list of other webmin servers

require './servers-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

@servers = sort { $a->{'host'} cmp $b->{'host'} } &list_servers();
if (@servers) {
	@titles = map { "$_->{'host'}:$_->{'port'}</a> <a href='edit_serv.cgi?id=$_->{'id'}'>(edit)" } @servers;
	@icons = map { "images/$_->{'type'}.gif" } @servers;
	@links = map { $_->{'user'} ? "link.cgi/$_->{'id'}/"
				    : &make_url($_) } @servers;
	&icons_table(\@links, \@titles, \@icons);
	}
else {
	print "<b>$text{'index_none'}</b> <p>\n";
	}

print "<a href='edit_serv.cgi?new=1'>$text{'index_add'}</a>. <p>\n";

print "<hr>\n";
print "<form action=find.cgi>\n";
print "<table width=100%><tr>\n";
print "<td><input type=submit value=\"$text{'index_find'}\"></td>\n";
print "<td>$text{'index_findmsg'}</td>\n";
print "</tr></table></form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

sub make_url
{
return sprintf "http%s://%s:%d/",
	$_[0]->{'ssl'} ? 's' : '', $_[0]->{'host'}, $_[0]->{'port'};
}
