#!/usr/local/bin/perl
# send_mail.cgi
# Send off an email message

require './sendmail-lib.pl';
require './boxes-lib.pl';

# Check inputs
&ReadParseMime();
&can_read_mail($in{'user'}) || &error($text{'send_ecannot'});
&error_setup($text{'send_err'});
$in{'to'} || &error($text{'send_eto'});
if ($access{'fmode'} == 0) {
	$in{'from'} || &error($text{'send_efrom'});
	}
elsif ($access{'fmode'} == 1) {
	foreach $f (split(/\s+/, $access{'from'})) {
		$found++ if ("$in{'user'}\@$f" eq $in{'from'});
		}
	&error($text{'send_efrom'}) if (!$found);
	}
elsif ($access{'fmode'} == 2) {
	foreach $f (split(/\s+/, $access{'from'})) {
		$found++ if ($f eq $in{'from'});
		}
	&error($text{'send_efrom'}) if (!$found);
	}
elsif ($access{'fmode'} == 3) {
	$in{'from'} .= "\@$access{'from'}";
	}

# Construct the email
$mail->{'headers'} = [ [ 'From', $in{'from'} ],
		       [ 'Subject', $in{'subject'} ],
		       [ 'To', $in{'to'} ],
		       [ 'Cc', $in{'cc'} ],
		       [ 'Bcc', $in{'bcc'} ],
		       [ 'X-Originating-IP', $ENV{'REMOTE_ADDR'} ],
		       [ 'X-Mailer', "Webmin ".&get_webmin_version() ] ];
push(@{$mail->{'headers'}}, [ 'X-Priority', $in{'pri'} ]) if ($in{'pri'});
$in{'body'} =~ s/\r//g;
if ($in{'body'} =~ /\S/) {
	@attach = ( { 'headers' => [ [ 'Content-Type', 'text/plain' ],
				     [ 'Content-Transfer-Encoding', '7bit' ] ],
		      'data' => $in{'body'} } );
	}
foreach $i (0 .. 5) {
	next if (!$in{"attach${i}"});
	local $type = $in{"attach${i}_content_type"}."; name=\"".
		      $in{"attach${i}_filename"}."\"";
	local $disp = "inline; filename=\"".
		      $in{"attach${i}_filename"}."\"";
	push(@attach, { 'data' => $in{"attach${i}"},
			'headers' => [ [ 'Content-type', $type ],
				       [ 'Content-Disposition', $disp ],
				       [ 'Content-Transfer-Encoding',
					 'base64' ] ] });
	}
@fwd = split(/\0/, $in{'forward'});
if (@fwd) {
	# Add forwarded attachments
	@mail = &list_mails($in{'user'}, $in{'idx'}, $in{'idx'});
	$fwdmail = $mail[$in{'idx'}];
	&parse_mail($fwdmail);
	foreach $f (@fwd) {
		push(@attach, $fwdmail->{'attach'}->[$f]);
		}
	}
$mail->{'attach'} = \@attach;

# Send it off
&send_mail($mail);
&header($text{'send_title'}, "");
print "<hr>\n";

print "<p>",&text('send_ok', "<tt>".&html_escape($in{'to'})."</tt>"),"<p>\n";
print "<hr>\n";
&footer("list_mail.cgi?user=$in{'user'}", $text{'mail_return'});

