#!/usr/local/bin/perl
# list_generics.cgi
# Display a list of addresses for outgoing address mapping

require './sendmail-lib.pl';
require './generics-lib.pl';
$access{'omode'} || &error($text{'generics_cannot'});
&header($text{'generics_title'}, "");
print "<hr>\n"; 

$conf = &get_sendmailcf();
$gfile = &generics_file($conf);
($gdbm, $gdbmtype) = &generics_dbm($conf);
if (!$gdbm) {
	# No Kgenerics directive in sendmail.cf
	print "<p><b>$text{'generics_econfig'}</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
if (!-r $gfile) {
	# Text file not found
	print "<p><b>",&text('generics_efile', "<tt>$gfile</tt>",
	      "<tt>$gdbm</tt>", "/config.cgi?$module_name"),"</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
@gens = &list_generics($gfile);
if ($access{'omode'} == 2) {
	@gens = grep { $_->{'from'} =~ /$access{'oaddrs'}/ } @gens;
	}

&generic_form();
if (@gens) {
	# sort if needed
	if ($config{'sort_mode'} == 1) {
		@gens = sort sort_by_domain @gens;
		}

	# render table of generics
	$mid = int((@gens+1)/2);
	print "<table width=100%> <tr><td width=50% valign=top>\n";
	&gens_table(@gens[0..$mid-1]);
	print "</td><td width=50% valign=top>\n";
	if ($mid < @gens) { &gens_table(@gens[$mid..$#gens]); }
	print "</td></tr> </table><br>\n";
	}

print $text{'generics_desc1'},"<p>\n";
print &text('generics_desc2', "list_cgs.cgi"),"<br>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub gens_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'generics_from'}</b></td> ",
      "<td><b>$text{'generics_to'}</b></td></tr>\n";
foreach $g (@_) {
	print "<tr $cb> <td><a href=\"edit_generic.cgi?num=$g->{'num'}\">",
	      "<tt>$g->{'from'}</tt></a></td>\n";
	print "<td>$g->{'to'}</td> </tr>\n";
	}
print "</table>\n";
}

# Notes - The G class lists domains for which outgoing-address translation
# is done. If a mapping for an address like 'foo' exists, it applied for
# from addresses like 'foo' or 'foo@anything'. However, a mapping for
# 'foo@foo.com' applies only for that exact address
# By default, the G class contains only the full local hostname 
# (like florissa.home). Sendmail automatically adds the full hostname
# to unqualified addresses sent locally or through smtp (so <foo> becomes
# <foo@florissa.home>
# The G class can be defined by CG statements in sendmail.cf, or by a
# FG/path line to use an external file..

# If there is a generics mapping from an unqualified name, then it will
# apply for all domains in the G class.

