#!/usr/local/bin/perl
# save_print.cgi
# Save inputs from conf_print.cgi

require './samba-lib.pl';
$whatfailed = "Failed to save options";
&ReadParse();
$global = &get_share("global");

&setval("printing", $in{printing}, "");

&setval("load printers", $in{load_printers}, "no");

if (!$in{printcap_name_def} && !(-r $in{printcap_name}) &&
    $in{printcap_name} !~ /\%/) {
	&error("The printcap file '$in{printcap_name}' does not exist");
	}
&setval("printcap name", $in{printcap_name_def} ? "" : $in{printcap_name}, "");

if (!$in{lpq_cache_time_def} && $in{lpq_cache_time} !~ /^\d+$/) {
	&error("'$in{lpq_cache_time}' is not a valid cache time");
	}
&setval("lpq cache time", $in{lpq_cache_time_def} ? 0 : $in{lpq_cache_time}, 0);

if ($global) { &modify_share("global", "global"); }
else { &create_share("global"); }
&redirect("");
