#!/usr/local/bin/perl
# save_pass.cgi
# Save inputs from conf_pass.cgi

require './samba-lib.pl';
$whatfailed = "Failed to save options";
&ReadParse();
$global = &get_share("global");

$nopass = (`$config{samba_password_program} 2>&1 </dev/null` =~ /encryption not selected/);
if ($in{encrypt_passwords} eq "yes" && $nopass) {
	&error("Your version of samba does not support encrypted passwords");
	}
&setval("encrypt passwords", $in{encrypt_passwords}, "no");

&setval("null passwords", $in{null_passwords}, "no");

if (!$in{passwd_program_def} && !$in{passwd_program}) {
	&error("No password changing program given");
	}
&setval("passwd program", $in{passwd_program_def}?"":$in{passwd_program}, "");

$in{password_level} =~ /^\d+$/ ||
	&error("'$in{password_level}' is not a valid password case difference");
&setval("password level", $in{password_level}, 0);

if ($in{passwd_chat_def}) { &delval("passwd chat"); }
else {
	for($i=0; defined($in{"chat_recv_$i"}); $i++) {
		push(@chat, $in{"chat_recv_$i"});
		push(@chat, $in{"chat_send_$i"});
		}
	$clast = -1;
	for($i=0; $i<@chat; $i++) {
		if ($chat[$i] =~ /\S/) { $clast = $i; }
		}
	if ($clast < 0) {
		&error("The change password chat sequence is empty");
		}
	@chat = @chat[0 .. $clast];
	@chat = map { /^$/ ? "." : /^\S+$/ ? $_ : "\"$_\""; } @chat;
	&setval("passwd chat", join(' ', @chat));
	}

$mapfile = &getval("username map");
if ($in{username_map_def}) { &delval("username map"); }
else {
	if (!$mapfile) {
		$config{smb_conf} =~ /^(.*)\/[^\/]+$/;
		$mapfile = "$1/user.map";
		}
	&setval("username map", $mapfile);
	for($i=0; defined($in{"umap_unix_$i"}); $i++) {
		if ($in{"umap_unix_$i"} =~ /\S/ && $in{"umap_win_$i"} =~ /\S/) {
			push(@umap, $in{"umap_unix_$i"}."=".$in{"umap_win_$i"});
			}
		}
	open(UMAP, "> $mapfile");
	foreach $line (@umap) {
		print UMAP "$line\n";
		}
	close(UMAP);
	}

if ($global) { &modify_share("global", "global"); }
else { &create_share("global"); }
&redirect("");

