#!/usr/local/bin/perl
# save_fshare.cgi
# Save a new or edited file share

require './samba-lib.pl';
$whatfailed = "Failed to save share";
&ReadParse();
if ($in{old_name}) {
	&get_share($in{old_name});
	}

# store share options
if ($in{old_name} eq "global") {
	$name = "global";
	}
else {
	$name = $in{"homes"} ? "homes" : $in{"share"};
	if ($in{"path"} !~ /\S/ && !$in{"homes"}) {
		&error("No path given");
		}
	}
&setval("path", $in{"path"});
&setval("available", $in{"available"});
&setval("browseable", $in{"browseable"});
&setval("comment", $in{"comment"});

# Check for clash
if ($name ne "global") {
	foreach (&list_shares()) {
		$exists{$_}++;
		}
	if (!$in{old_name} && $exists{$name}) {
		&error("A share called '$name' already exists");
		}
	elsif ($in{old_name} ne $name && $exists{$name}) {
		&error("A share called '$name' already exists");
		}
	elsif ($name !~ /^[A-z0-9_\$ ]+$/) {
		&error("'$name' is not a valid share name");
		}
	elsif ($name eq "global") {
		&error("The name 'global' cannot be used for a share");
		}
	}

# Update config file
if ($in{old_name}) {
	# Changing an existing share
	&modify_share($in{old_name}, $name);
	}
else {
	# Creating a new share
	&create_share($name);
	}
&redirect("");

