#!/usr/local/bin/perl
# save_fshare.cgi
# Save a new or edited file share

require './samba-lib.pl';
$whatfailed = "Failed to save miscellaneous options";
&ReadParse();
&get_share($in{old_name});

# Random options
&setval("mangled map", $in{mangled_map});
&setval("locking", $in{locking});
if ($in{max_connections_def}) { &setval("max connections", 0); }
else {
	($in{max_connections} =~ /^\d+$/ && $in{max_connections} > 0) ||
		&error("'".$in{max_connections}.
		       "' is not a valid number of connections");
	&setval("max connections", $in{max_connections});
	}
&setval("fake oplocks", $in{fake_oplocks});
&setval("share modes", $in{share_modes});
&setval("strict locking", $in{strict_locking});
&setval("sync always", $in{sync_always});
&setval("volume", $in{volume_def} ? "" : $in{volume});
&setval("preexec", $in{preexec});
&setval("postexec", $in{postexec});
&setval("root preexec", $in{root_preexec});
&setval("root postexec", $in{root_postexec});

&modify_share($in{old_name}, $in{old_name});
&redirect("edit_fshare.cgi?share=".&urlize($in{old_name}));

