#!/usr/local/bin/perl
# edit_sec.cgi
# Edit security options for some file or print share

require './samba-lib.pl';
&ReadParse();
$s = $in{'share'};
if ($s eq "global") {
	&header("Security Defaults", "");
	}
else {
	&header("Edit Security", "");
	print "<center><font size=+1>For share <tt>$s</tt></font></center>\n";
	}
&get_share($s);
print "<hr>\n";

print "<form action=save_sec.cgi>\n";
print "<input type=hidden name=old_name value=\"$s\">\n";

print "<table border width=100%>\n";
print "<tr $tb> <td><b>Security and Access Control</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td align=right><b>Writable?</b></td>\n";
print "<td>",&yesno_input("writable"),"</td>\n";

print "<td align=right><b>Guest Access?</b></td>\n";
printf "<td><input type=radio name=guest value=0 %s> None\n",
	&istrue("public") ? "" : "checked";
printf "<input type=radio name=guest value=1 %s> Yes\n",
	&istrue("public") && !&istrue("guest only") ? "checked" : "";
printf "<input type=radio name=guest value=2 %s> Guest only</td> </tr>\n",
	&istrue("public") && &istrue("guest only") ? "checked" : "";

print "<tr> <td align=right><b>Guest Unix user</b></td>\n";
&username_input("guest account", "Default");

print "<td align=right><b>Limit to possible list?</b></td>\n";
print "<td>",&yesno_input("only user"),"</td> </tr>\n";

print "<tr> <td align=right><b>Hosts to allow</b></td>\n";
printf "<td colspan=3><input type=radio name=allow_hosts_all value=1 %s> All\n",
	&getval("allow hosts") eq "" ? "checked" : "";
print "&nbsp;&nbsp;\n";
printf "<input type=radio name=allow_hosts_all value=0 %s> Only allow:\n",
	&getval("allow hosts") eq "" ? "" : "checked";
printf "<input name=allow_hosts size=35 value=\"%s\"></td> </tr>\n",
	&getval("allow hosts");

print "<tr> <td align=right><b>Hosts to deny</b></td>\n";
printf "<td colspan=3><input type=radio name=deny_hosts_all value=1 %s> None\n",
	&getval("deny hosts") eq "" ? "checked" : "";
print "&nbsp;&nbsp;\n";
printf "<input type=radio name=deny_hosts_all value=0 %s> Only deny:\n",
	&getval("deny hosts") eq "" ? "" : "checked";
printf "<input name=deny_hosts size=35 value=\"%s\"></td> </tr>\n",
	&getval("deny hosts");

print "<tr> <td align=right><b>Revalidate users?</b></td>\n";
print "<td>",&yesno_input("revalidate"),"</td> </tr>\n";

@valid_users = split(/\s*,\s*/, &getval("valid users"));
print "<tr> <td align=right><b>Valid users</b></td> <td colspan=3>\n";
printf "<input name=valid_users_u size=40 value=\"%s\"> %s</td> </tr>\n",
	join(' ', grep { !/^@/ } @valid_users),
	&user_chooser_button("valid_users_u", 1);
print "<tr> <td align=right><b>Valid groups</b></td> <td colspan=3>\n";
printf "<input name=valid_users_g size=40 value=\"%s\"> %s</td> </tr>\n",
	join(' ', map { s/@//;$_ } grep { /^@/ } @valid_users),
	&group_chooser_button("valid_users_g", 1);

@invalid_users = split(/\s*,\s*/, &getval("invalid users"));
print "<tr> <td align=right><b>Invalid users</b></td> <td colspan=3>\n";
printf "<input name=invalid_users_u size=40 value=\"%s\"> %s</td> </tr>\n",
	join(' ', grep { !/^@/ } @invalid_users),
	&user_chooser_button("invalid_users_u", 1);
print "<tr> <td align=right><b>Invalid groups</b></td> <td colspan=3>\n";
printf "<input name=invalid_users_g size=40 value=\"%s\"> %s</td> </tr>\n",
	join(' ', map { s/@//;$_ } grep { /^@/ } @invalid_users),
	&group_chooser_button("invalid_users_g", 1);

print "<tr> <td colspan=4><hr></td> </tr>\n";

@user = split(/\s*,\s*/, &getval("user"));
print "<tr> <td align=right><b>Possible users</b></td> <td>\n";
printf "<input name=user_u size=20 value=\"%s\"> %s</td>\n",
	join(' ', grep { !/^@/ } @user),
	&user_chooser_button("user_u", 1);
print "<td align=right><b>Possible groups</b></td> <td colspan=3>\n";
printf "<input name=user_g size=20 value=\"%s\"> %s</td> </tr>\n",
	join(' ', map { s/@//;$_ } grep { /^@/ } @user),
	&group_chooser_button("user_g", 1);

@read_list = split(/\s*,\s*/, &getval("read list"));
print "<tr> <td align=right><b>Read only users</b></td> <td>\n";
printf "<input name=read_list_u size=20 value=\"%s\"> %s</td>\n",
	join(' ', grep { !/^@/ } @read_list),
	&user_chooser_button("read_list_u", 1);
print "<td align=right><b>Read only groups</b></td> <td colspan=3>\n";
printf "<input name=read_list_g size=20 value=\"%s\"> %s</td> </tr>\n",
	join(' ', map { s/@//;$_ } grep { /^@/ } @read_list),
	&group_chooser_button("read_list_g", 1);

@write_list = split(/\s*,\s*/, &getval("write list"));
print "<tr> <td align=right><b>Read/write users</b></td> <td>\n";
printf "<input name=write_list_u size=20 value=\"%s\"> %s</td>\n",
	join(' ', grep { !/^@/ } @write_list),
	&user_chooser_button("write_list_u", 1);
print "<td align=right><b>Read/write groups</b></td> <td>\n";
printf "<input name=write_list_g size=20 value=\"%s\"> %s</td> </tr>\n",
	join(' ', map { s/@//;$_ } grep { /^@/ } @write_list),
	&group_chooser_button("write_list_g", 1);

print "</table><table border width=100%>\n";

print "</table> </td></tr></table><p>\n";
print "<input type=submit value=Save></form>\n";
print "<hr>\n";
if (&istrue("printable"))
	{ &footer("edit_pshare.cgi?share=".&urlize($s), "print share"); }
else
	{ &footer("edit_fshare.cgi?share=".&urlize($s), "file share"); }

