#!/usr/local/bin/perl
# index.cgi
# Display a list of all local filesystems, and allow editing of quotas
# on those which have quotas turned on. The actual turning on of quotas must
# be done in the mount module first.

require './quota-lib.pl';
&header("Disk Quotas", "", "intro", "quota", 1);
print "<hr>\n";

$err = &quotas_init();
if ($err) {
	print "<p><b>$err</b><p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

@list = &list_filesystems();
if (@list) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>Filesystem</b></td> <td><b>Type</b></td>\n";
	print "<td><b>Mounted From</b></td> <td><b>Status</b></td>\n";
	if ($access{'enable'}) {
		print "<td><b>Action</b></td> </tr>\n";
		}
	else { print "</tr>\n"; }
	foreach $f (@list) {
		$qc = $f->[4];
		$qc = $qc&1 if ($access{'gmode'} == 3);
		next if (!$qc);
		next if (!&can_edit_filesys($f->[0]));
		$qn = $f->[5];
		if ($qc == 1) { $msg = "User Quotas"; }
		elsif ($qc == 2) { $msg = "Group Quotas"; }
		elsif ($qc == 3) { $msg = "User and Group Quotas"; }
		if ($qn) { $msg .= " Active"; $chg = "Disable Quotas"; }
		else { $msg .= " Inactive"; $chg = "Enable Quotas"; }
		if ($qn%2 == 1) { $useractive++; }
		if ($qn > 1) { $groupactive++; }

		print "<tr $cb><td>\n";
		$dir = $f->[0];
		if (!$qn) { print $dir; }
		elsif ($qc == 1)
			{ print "<a href=\"list_users.cgi?$dir+$qc\">$dir</a>";}
		elsif ($qc == 2)
			{ print"<a href=\"list_groups.cgi?$dir+$qc\">$dir</a>";}
		elsif ($qc == 3) {
			print "<a href=\"list_users.cgi?$dir+$qc\">$dir (users)</a><br>";
			print "<a href=\"list_groups.cgi?$dir+$qc\">$dir (groups)</a>";
			}
		print "</td>\n";

		print "<td valign=top>",&foreign_call(
			"mount", "fstype_name", $f->[2]),"</td>\n";
		print "<td valign=top>$f->[1]</td>\n";
		print "<td valign=top>$msg</td>\n";
		if ($access{'enable'}) {
			print "<td valign=top><a href=\"activate.cgi?dir=$dir&",
			      "active=$qn&mode=$qc\">$chg</a></td>\n";
			}

		print "</tr>\n";
		}
	print "</table>\n";
	}
else { print "<b>No local filesystems can support quotas</b>.<br>\n"; }

print "<table width=100%><tr>\n";
if ($useractive) {
	print "<form action=user_filesys.cgi>\n";
	print "<td><input type=submit value=\"Edit User Quotas:\">\n";
	print "<input name=user size=8> ",
	      &user_chooser_button("user", 0),"</td></form>\n";
	}
else { print "<td></td>\n"; }

if ($groupactive) {
	print "<form action=group_filesys.cgi>\n";
	print "<td align=right>\n";
	print "<input type=submit value=\"Edit Group Quotas:\">\n";
	print "<input name=group size=8> ",
	      &group_chooser_button("group", 0, $useractive ? 1 : 0),
	      "</td></form>\n";
	}
else { print "<td></td>\n"; }
print "</tr></table>\n";

print "<hr>\n";
&footer("/", "index");

